/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.SubstitutionVariables;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class Config {
    private final Object value;
    private final Config parent;
    private final SubstitutionVariables substitutions;
    private static final Set<Class<?>> PRIMITIVE_BOXED = Set.of(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class);

    private Config(Object value, Map<String, String> properties) {
        this.value = value;
        this.parent = null;
        this.substitutions = SubstitutionVariables.of(properties);
    }

    private Config(Object value, Config parent) {
        this.value = value;
        this.parent = parent;
        this.substitutions = parent.substitutions;
    }

    public Config parent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == this;
    }

    public Config get(String key) {
        Object v = this.value instanceof Map ? ((Map)this.value).get(key) : null;
        return new Config(v, this);
    }

    public boolean containsKey(String key) {
        if (this.value instanceof Map) {
            return ((Map)this.value).containsKey(key);
        }
        return false;
    }

    public Optional<Config> asOptional() {
        return this.value == null ? Optional.empty() : Optional.of(this);
    }

    public Optional<String> asString() {
        return this.as(String.class);
    }

    public Optional<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    public <T> Optional<T> as(Function<Object, T> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(mapper.apply(this.value));
        }
        catch (Throwable ex) {
            throw new MappingException(ex);
        }
    }

    public <T> Optional<T> as(Class<T> type) {
        return this.as((Object o) -> this.cast(o, type));
    }

    public Optional<List<Config>> asNodeList() {
        return this.asList((Object e) -> new Config(e, this));
    }

    public Optional<List<Object>> asList() {
        return this.asList(Function.identity());
    }

    public <T> Optional<List<T>> asList(Class<T> type) {
        return this.asList((Object e) -> this.cast(e, type));
    }

    public <T> Optional<List<T>> asList(Function<Object, T> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof List) {
            return Optional.of(((List)this.value).stream().map(mapper).collect(Collectors.toList()));
        }
        throw new MappingException(this.value.getClass(), List.class);
    }

    public <T> Optional<Map<String, T>> asMap(Function<Object, T> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof Map) {
            return Optional.of(((Map)this.value).entrySet().stream().map(e -> Map.entry(e.getKey().toString(), mapper.apply(e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        throw new MappingException(this.value.getClass(), Map.class);
    }

    public Optional<Map<String, Object>> asMap() {
        return this.asMap(Function.identity());
    }

    public <T> Optional<Map<String, T>> asMap(Class<T> type) {
        return this.asMap((Object e) -> this.cast(e, type));
    }

    public static Config create(Object value, Map<String, String> properties) {
        return new Config(value, properties);
    }

    public static Config create(String path, Class<?> clazz, Map<String, String> properties) {
        return Config.create(FileUtils.resourceAsPath((String)path, clazz), properties);
    }

    public static Config create(Path path, Map<String, String> properties) {
        try {
            return Config.create(Files.newBufferedReader(path), properties);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static Config create(Reader reader, Map<String, String> properties) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        return Config.create(yaml.loadAs(reader, Object.class), properties);
    }

    private <T> T cast(Object obj, Class<T> type) {
        if (obj != null) {
            if (type.equals(String.class) || obj.getClass().isPrimitive() || PRIMITIVE_BOXED.contains(obj.getClass())) {
                return type.cast(this.substitutions.resolve(String.valueOf(obj)));
            }
            if (type.isInstance(obj)) {
                return type.cast(obj);
            }
            throw new MappingException(obj.getClass(), type);
        }
        return null;
    }

    public static class MappingException
    extends RuntimeException {
        private MappingException(Class<?> actual, Class<?> expected) {
            super(String.format("Cannot get a %s as %s", actual.getSimpleName(), expected.getSimpleName()));
        }

        private MappingException(Throwable cause) {
            super(cause);
        }
    }
}

