/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.Instance;
import io.helidon.build.common.SourcePath;
import io.helidon.build.common.Strings;
import io.helidon.build.common.VirtualFileSystem;
import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Backend;
import io.helidon.build.maven.sitegen.PageRenderer;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.Site;
import io.helidon.build.maven.sitegen.freemarker.TemplateSession;
import io.helidon.build.maven.sitegen.models.Page;
import io.helidon.build.maven.sitegen.models.PageFilter;
import io.helidon.build.maven.sitegen.models.SourcePathFilter;
import io.helidon.build.maven.sitegen.models.StaticAsset;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class Context {
    private static final ThreadLocal<Deque<Context>> REGISTRY = ThreadLocal.withInitial(ArrayDeque::new);
    private final Site site;
    private final TemplateSession templateSession;
    private final Path sourceDir;
    private final Path outputDir;
    private final Map<String, String> assets;
    private volatile List<RenderingException> errors;
    private final Instance<Map<String, Page>> pages;
    private final Instance<List<SourcePath>> sourcePaths;
    private final Instance<List<String>> resolvedAssets;

    public Context(Site site, Path sourceDir, Path outputDir) {
        this.site = Objects.requireNonNull(site, "site is null!");
        this.sourceDir = FileUtils.requireDirectory((Path)sourceDir);
        this.outputDir = VirtualFileSystem.create((Path)outputDir).getPath("/", new String[0]);
        this.templateSession = TemplateSession.create();
        this.assets = new HashMap<String, String>();
        this.sourcePaths = new Instance(this::initSourcePaths);
        this.resolvedAssets = new Instance(this::initResolvedAssets);
        this.pages = new Instance(this::initPages);
    }

    public void runInContext(Runnable runnable) {
        this.runInContext(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> T runInContext(Callable<T> callable) {
        try {
            REGISTRY.get().push(this);
            ArrayList<RenderingException> errors = new ArrayList<RenderingException>();
            this.errors = errors;
            T result = callable.call();
            if (!errors.isEmpty()) {
                throw new RenderingException(errors);
            }
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            REGISTRY.get().pop();
        }
    }

    public static Context get() {
        Context ctx = REGISTRY.get().peek();
        if (ctx != null) {
            return ctx;
        }
        throw new IllegalStateException("context is not set!");
    }

    public void error(RenderingException ex) {
        if (this.errors == null) {
            throw ex;
        }
        this.errors.add(ex);
    }

    public Path sourceDir() {
        return this.sourceDir;
    }

    public Path outputDir() {
        return this.outputDir;
    }

    public TemplateSession templateSession() {
        return this.templateSession;
    }

    public <T> Optional<T> option(String key, Class<T> type) {
        return Optional.ofNullable(this.site.options().get(key)).map(type::cast);
    }

    public int failOn() {
        String severity;
        switch (severity = this.option("fail-on", String.class).orElse("WARN")) {
            case "DEBUG": {
                return 0;
            }
            case "INFO": {
                return 1;
            }
            case "WARN": {
                return 2;
            }
            case "ERROR": {
                return 3;
            }
            case "FATAL": {
                return 4;
            }
        }
        return 5;
    }

    public boolean strictXRef() {
        return this.option("strict-xref", Boolean.class).orElse(true);
    }

    public boolean strictTemplates() {
        return this.option("strict-templates", Boolean.class).orElse(true);
    }

    public boolean strictImages() {
        return this.option("strict-images", Boolean.class).orElse(true);
    }

    public Site site() {
        return this.site;
    }

    public Map<String, Page> pages() {
        return (Map)this.pages.instance();
    }

    public Page pageForRoute(String route) {
        Strings.requireValid((String)route, (String)"route is invalid!");
        for (Page page : this.pages().values()) {
            if (!route.equals(page.target())) continue;
            return page;
        }
        return null;
    }

    public Page resolvePage(Page page, String path) {
        Path resolvedPath = this.resolvePath(page, path);
        String key = Strings.normalizePath((Object)this.sourceDir.relativize(resolvedPath));
        return this.pages().get(key);
    }

    public Path resolvePath(Page page, String path) {
        Path pageDir = this.pageDir(page.source());
        return pageDir.resolve(path).normalize();
    }

    public Path pageDir(String path) {
        Path pageSource = this.sourceDir.resolve(path);
        return pageSource.getParent().normalize();
    }

    public List<String> resolvedAssets() {
        return (List)this.resolvedAssets.instance();
    }

    public void copyStaticAssets() {
        for (Map.Entry<String, String> asset : this.assets.entrySet()) {
            try {
                String source = asset.getKey();
                String target = asset.getValue();
                Path targetDir = this.outputDir.resolve(target);
                Files.createDirectories(targetDir, new FileAttribute[0]);
                Context.copyResources(this.sourceDir.resolve(source), targetDir.resolve(source));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public void processPages(Path pagesDir, String ext) {
        Backend backend = this.site.backend();
        this.pages().values().stream().sorted(Comparator.comparing(Page::source)).forEach(page -> {
            PageRenderer renderer = backend.renderer(pagesDir.resolve(page.source()));
            renderer.process((Page)page, this, pagesDir, ext);
        });
    }

    private List<SourcePath> initSourcePaths() {
        return SourcePath.scan((Path)this.sourceDir);
    }

    private Map<String, Page> initPages() {
        ArrayList<SourcePath> resolvedPaths;
        List<PageFilter> filters = this.site.pages();
        Log.debug((String)"creating pages, dir=%s, filters:%s", (Object[])new Object[]{this.sourceDir, this.site.pages()});
        ArrayList<SourcePath> paths = (ArrayList<SourcePath>)this.sourcePaths.instance();
        if (filters.isEmpty()) {
            resolvedPaths = paths;
        } else {
            resolvedPaths = new ArrayList<SourcePath>();
            for (SourcePathFilter sourcePathFilter : this.site.pages()) {
                resolvedPaths.addAll(sourcePathFilter.resolvePaths(paths));
            }
        }
        Log.debug((String)"resolved paths: %s", (Object[])new Object[]{resolvedPaths});
        Backend backend = this.site.backend();
        HashMap<String, Page> hashMap = new HashMap<String, Page>();
        for (SourcePath filteredPath : SourcePath.sort(resolvedPaths)) {
            String path = filteredPath.asString(false);
            if (hashMap.containsKey(path)) {
                throw new IllegalStateException("Source path " + path + "already included");
            }
            Log.debug((String)"creating page: %s", (Object[])new Object[]{path});
            PageRenderer renderer = backend.renderer(this.sourceDir.resolve(path));
            Page.Metadata metadata = renderer.readMetadata(this.sourceDir.resolve(path));
            hashMap.put(path, Page.builder().source(path).target(Page.removeFileExt(path)).metadata(metadata).build());
        }
        return hashMap;
    }

    private List<String> initResolvedAssets() {
        ArrayList<String> resolvedAssets = new ArrayList<String>();
        List sourcePaths = (List)this.sourcePaths.instance();
        for (StaticAsset asset : this.site.assets()) {
            for (SourcePath path : asset.resolvePaths(sourcePaths)) {
                String source = path.asString(false);
                String target = asset.target();
                this.assets.put(source, target);
                Path targetPath = this.outputDir.resolve(target).resolve(source).normalize();
                resolvedAssets.add(targetPath.toString());
            }
        }
        return resolvedAssets;
    }

    public static void copyResources(final Path resources, final Path outputDir) {
        try {
            Files.walkFileTree(resources, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!Files.isDirectory(file, new LinkOption[0])) {
                        String targetRelativePath = resources.relativize(file).toString();
                        Path targetPath = outputDir.resolve(targetRelativePath);
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        Log.debug((String)"Copying static resource: %s to %s", (Object[])new Object[]{targetRelativePath, targetPath});
                        Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException ex) {
                    Log.error((String)"Error while copying static resource: %s - %s", (Object[])new Object[]{file.getFileName(), ex.getMessage()});
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

