/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.maven.sitegen.Backend;
import io.helidon.build.maven.sitegen.BasicBackend;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.SiteEngine;
import io.helidon.build.maven.sitegen.models.Header;
import io.helidon.build.maven.sitegen.models.Page;
import io.helidon.build.maven.sitegen.models.PageFilter;
import io.helidon.build.maven.sitegen.models.StaticAsset;
import io.helidon.build.maven.sitegen.spi.BackendProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Site {
    private final SiteEngine engine;
    private final List<StaticAsset> assets;
    private final Header header;
    private final List<PageFilter> pages;
    private final Backend backend;
    private final Map<String, Object> options;

    private Site(Builder builder) {
        this.backend = Optional.ofNullable(builder.backend).orElseGet(BasicBackend::create);
        this.engine = Optional.ofNullable(builder.engine).orElseGet(() -> SiteEngine.builder().backend(this.backend.name())).site(this).build();
        this.header = Optional.ofNullable(builder.header).orElseGet(Header::create);
        this.options = builder.options;
        this.assets = builder.assets;
        this.pages = builder.pages;
    }

    public SiteEngine engine() {
        return this.engine;
    }

    public List<StaticAsset> assets() {
        return this.assets;
    }

    public Header header() {
        return this.header;
    }

    public List<PageFilter> pages() {
        return this.pages;
    }

    public Backend backend() {
        return this.backend;
    }

    public void generate(Path sourceDir, Path outputDir) throws RenderingException {
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            Context ctx = new Context(this, sourceDir, outputDir);
            ctx.runInContext(() -> this.backend.generate(ctx));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Page.Metadata readMetadata(Path source) {
        Context context = new Context(this, source.getParent(), null);
        return context.runInContext(() -> this.backend.renderer(source).readMetadata(source));
    }

    public Map<String, Object> options() {
        return this.options;
    }

    public static Site create(Config config) {
        return Site.builder().config(config).build();
    }

    public static Site create(Backend backend) {
        return Site.builder().backend(backend).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Backend backend;
        private SiteEngine.Builder engine;
        private Header header;
        private final Map<String, Object> options = new HashMap<String, Object>();
        private final List<StaticAsset> assets = new ArrayList<StaticAsset>();
        private final List<PageFilter> pages = new ArrayList<PageFilter>();

        public Builder options(Map<String, Object> options) {
            if (options != null) {
                this.options.putAll(options);
            }
            return this;
        }

        public Builder config(Config config) {
            return this.config(config, Map.of());
        }

        public Builder config(Config config, Map<String, String> properties) {
            this.backend = config.get("backend").asOptional().map(BackendProvider::get).orElseGet(BasicBackend::create);
            this.engine = SiteEngine.builder().backend(this.backend.name());
            this.header = config.get("header").asOptional().map(Header::create).orElse(null);
            config.get("engine").asOptional().ifPresent(c -> this.engine.config((Config)c));
            config.get("assets").asNodeList().orElseGet(List::of).stream().map(StaticAsset::create).forEach(this.assets::add);
            this.options.putAll(config.get("options").asMap().orElseGet(Map::of));
            config.get("pages").asNodeList().orElseGet(List::of).stream().map(PageFilter::create).forEach(this.pages::add);
            return this;
        }

        public Builder pages(List<PageFilter> pages) {
            if (pages != null) {
                this.pages.addAll(pages);
            }
            return this;
        }

        public Builder page(Supplier<PageFilter> supplier) {
            if (supplier != null) {
                this.pages.add(supplier.get());
            }
            return this;
        }

        public Builder page(PageFilter page) {
            if (page != null) {
                this.pages.add(page);
            }
            return this;
        }

        public Builder engine(SiteEngine.Builder builder) {
            if (this.backend != null) {
                builder.backend(this.backend.name());
            }
            this.engine = builder;
            return this;
        }

        public Builder engine(Consumer<SiteEngine.Builder> consumer) {
            SiteEngine.Builder builder = SiteEngine.builder();
            if (this.backend != null) {
                builder.backend(this.backend.name());
            }
            consumer.accept(builder);
            this.engine = builder;
            return this;
        }

        public Builder backend(Backend backend) {
            this.backend = backend;
            return this;
        }

        public Builder backend(Supplier<? extends Backend> supplier) {
            this.backend = supplier.get();
            return this;
        }

        public Builder header(Header header) {
            this.header = header;
            return this;
        }

        public Builder header(Supplier<Header> supplier) {
            if (supplier != null) {
                this.header = supplier.get();
            }
            return this;
        }

        public Builder assets(List<StaticAsset> assets) {
            if (assets != null) {
                this.assets.addAll(assets);
            }
            return this;
        }

        public Builder asset(StaticAsset asset) {
            if (asset != null) {
                this.assets.add(asset);
            }
            return this;
        }

        public Builder asset(Supplier<StaticAsset> supplier) {
            if (supplier != null) {
                this.assets.add(supplier.get());
            }
            return this;
        }

        public Site build() {
            return new Site(this);
        }
    }

    public static final class Options {
        public static final String STRICT_XREF = "strict-xref";
        public static final String STRICT_TEMPLATES = "strict-templates";
        public static final String STRICT_IMAGES = "strict-images";
        public static final String FAIL_ON = "fail-on";
    }
}

