/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.PageRenderer;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocEngine;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocHeaders;
import io.helidon.build.maven.sitegen.models.Page;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public final class AsciidocPageRenderer
implements PageRenderer {
    private final AsciidocEngine asciidocEngine;

    public AsciidocPageRenderer(AsciidocEngine asciidocEngine) {
        this.asciidocEngine = Objects.requireNonNull(asciidocEngine, "asciidocEngine is null!");
    }

    @Override
    public void process(Page page, Context ctx, Path outputDir, String ext) {
        Objects.requireNonNull(page, "page is null!");
        Objects.requireNonNull(ctx, "ctx is null!");
        Strings.requireValid((String)ext, (String)"ext is invalid!");
        Path target = FileUtils.requireDirectory((Path)outputDir).resolve(page.target() + "." + ext);
        this.asciidocEngine.render(page, ctx, target);
    }

    @Override
    public boolean supports(Path source) {
        return "adoc".equals(FileUtils.fileExt((Path)source));
    }

    @Override
    public Page.Metadata readMetadata(Path source) {
        Objects.requireNonNull(source, "source is null!");
        Map<String, Object> docHeader = AsciidocHeaders.readDocumentHeader(source);
        return Page.Metadata.create(Config.create(docHeader, Map.of()));
    }
}

