/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Model;
import java.util.function.Supplier;

public class Glyph
implements Model {
    private final String type;
    private final String value;

    private Glyph(Builder builder) {
        this.type = Strings.requireValid((String)builder.type, (String)"type is invalid!");
        this.value = Strings.requireValid((String)builder.value, (String)"glyph is invalid!");
    }

    public String type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "type": {
                return this.type;
            }
            case "value": {
                return this.value;
            }
        }
        throw new IllegalArgumentException("Unknown attribute: " + attr);
    }

    public String toString() {
        return "Glyph{type='" + this.type + "', value='" + this.value + "'}";
    }

    public static Glyph create(Config config) {
        return Glyph.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<Glyph> {
        private String type;
        private String value;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder config(Config config) {
            this.type = config.get("type").asString().orElse(null);
            this.value = config.get("value").asString().orElse(null);
            return this;
        }

        public Glyph build() {
            return new Glyph(this);
        }

        @Override
        public Glyph get() {
            return this.build();
        }
    }
}

