/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Model;
import java.util.Objects;
import java.util.function.Supplier;

public final class WebResource
implements Model {
    private final Location location;
    private final String type;

    private WebResource(Builder builder) {
        this.location = Objects.requireNonNull(builder.location, "location is null!");
        this.type = builder.type;
    }

    public Location location() {
        return this.location;
    }

    public String type() {
        return this.type;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "location": {
                return this.location.value;
            }
            case "type": {
                return this.type;
            }
        }
        throw new IllegalArgumentException("Unknown attribute: " + attr);
    }

    public String toString() {
        return "WebResource{location=" + this.location + ", type='" + this.type + "'}";
    }

    public static WebResource create(Config config) {
        return WebResource.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<WebResource> {
        private Location location;
        private String type;

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder location(Location.Type type, String value) {
            this.location = Location.create(type, value);
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder config(Config config) {
            this.type = config.get("type").asString().orElse(null);
            this.location = Location.create(config);
            return this;
        }

        @Override
        public WebResource get() {
            return this.build();
        }

        public WebResource build() {
            return new WebResource(this);
        }
    }

    public static final class Location
    implements Model {
        private final String value;
        private final Type type;

        private Location(Type type, String value) {
            this.type = Objects.requireNonNull(type, "type is null!");
            this.value = Strings.requireValid((String)value, (String)"value is invalid!");
        }

        public Type type() {
            return this.type;
        }

        public String value() {
            return this.value;
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "type": {
                    return this.type;
                }
                case "value": {
                    return this.value;
                }
            }
            throw new IllegalArgumentException("Unknown attribute: " + attr);
        }

        public static Location create(Type type, String value) {
            return new Location(type, value);
        }

        public static Location create(Config config) {
            return Location.create(config.get("href").asString().orElse(null), (String)config.get("path").asString().orElse(null));
        }

        public static Location create(String href, String path) {
            if (href != null) {
                return new Location(Type.HREF, href);
            }
            if (path != null) {
                return new Location(Type.PATH, path);
            }
            throw new IllegalArgumentException("Invalid location");
        }

        public static enum Type {
            PATH,
            HREF;

        }
    }
}

