/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import freemarker.template.TemplateException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RenderingException
extends RuntimeException {
    public RenderingException(String msg) {
        this(msg, true);
    }

    public RenderingException(List<RenderingException> errors) {
        this(errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator())));
    }

    public RenderingException(String msg, Throwable cause) {
        this(msg, cause, true);
    }

    private RenderingException(String msg, boolean filterStackTrace) {
        super(msg);
        if (filterStackTrace) {
            this.setStackTrace(RenderingException.filteredStackTrace(this.getStackTrace()));
        }
    }

    private RenderingException(String msg, Throwable cause, boolean filterStackTrace) {
        super(msg, cause);
        if (filterStackTrace) {
            this.setStackTrace(RenderingException.filteredStackTrace(this.getStackTrace()));
        }
    }

    public static Throwable cause(Throwable cause) {
        ArrayDeque<Throwable> causes = new ArrayDeque<Throwable>();
        while (cause != null) {
            causes.push(cause);
            cause = cause.getCause();
        }
        while (!causes.isEmpty()) {
            Throwable ex = (Throwable)causes.pop();
            StackTraceElement[] ste = RenderingException.filteredStackTrace(ex.getStackTrace());
            if (ex instanceof TemplateException) {
                String msg = RenderingException.filterMsg(ex.getMessage());
                ex = cause != null ? new RenderingException(msg, cause, false) : new RenderingException(msg, false);
            }
            ex.setStackTrace(ste);
            cause = ex;
        }
        return cause;
    }

    private static String filterMsg(String message) {
        return Arrays.stream(message.split("\\R")).limit(2L).collect(Collectors.joining(System.lineSeparator()));
    }

    private static StackTraceElement[] filteredStackTrace(StackTraceElement[] elements) {
        return (StackTraceElement[])Arrays.stream(elements).filter(RenderingException::filterStackTrace).toArray(StackTraceElement[]::new);
    }

    private static boolean filterStackTrace(StackTraceElement elt) {
        return !elt.getClassName().startsWith("org.jruby") && (elt.getFileName() == null || !elt.getFileName().endsWith(".rb"));
    }
}

