/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.helidon.build.common.FileUtils;
import io.helidon.build.common.MediaTypes;
import io.helidon.build.common.Strings;
import io.helidon.build.common.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.LockSupport;

public final class SiteServer {
    private final int port;
    private final HttpServer server;
    private volatile Thread blockerThread;

    public SiteServer(int port, Path dir) {
        this.port = port;
        try {
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            this.server.createContext("/", new Handler(dir));
            this.server.setExecutor(Executors.newWorkStealingPool());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public int port() {
        return this.port;
    }

    public void start() {
        this.server.start();
        Log.info((String)"Site server is up! $(blue http://localhost:%d)", (Object[])new Object[]{this.port});
        this.blockerThread = Thread.currentThread();
        LockSupport.park();
    }

    public void stop() {
        LockSupport.unpark(this.blockerThread);
        this.server.stop(0);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Path dir = Path.of(args[0], new String[0]);
            int port = 8080;
            if (args.length > 1) {
                port = Integer.parseInt(args[1]);
            }
            new SiteServer(port, dir).start();
        }
        throw new IllegalArgumentException("usage: dir [port]");
    }

    private static final class Handler
    implements HttpHandler {
        private final Path dir;

        Handler(Path dir) {
            this.dir = dir;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                String path = exchange.getRequestURI().getPath();
                if (path.matches("^/.*\\.\\w{2,}$")) {
                    this.serveFile(exchange, path);
                } else {
                    this.serveFile(exchange, "/index.html");
                }
            } else {
                exchange.sendResponseHeaders(400, 0L);
            }
            exchange.close();
        }

        private void serveFile(HttpExchange exchange, String path) throws IOException {
            block13: {
                Path file = this.dir.resolve(Strings.stripLeading((String)path, (char)'/'));
                if (Files.exists(file, new LinkOption[0])) {
                    String mediaType = MediaTypes.of((String)FileUtils.fileExt((Path)file)).orElse("application/octet-stream");
                    exchange.getResponseHeaders().add("Content-Type", mediaType);
                    exchange.sendResponseHeaders(200, Files.size(file));
                    try (OutputStream os = exchange.getResponseBody();
                         InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                        is.transferTo(os);
                        break block13;
                    }
                }
                exchange.sendResponseHeaders(404, 0L);
            }
        }
    }
}

