/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.SiteEngine;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocRenderingException;
import io.helidon.build.maven.sitegen.freemarker.FreemarkerEngine;
import io.helidon.build.maven.sitegen.models.Page;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.converter.AbstractConverter;

public class AsciidocConverter
extends AbstractConverter<String> {
    private final FreemarkerEngine templateEngine;
    private final Deque<String> frames = new ArrayDeque<String>();
    private final Context ctx = Context.get();
    private volatile Page page;
    private volatile Document document;

    public AsciidocConverter(String backend, Map<String, Object> opts) {
        super(backend, opts);
        SiteEngine engine = this.ctx.site().engine();
        this.templateEngine = engine.freemarker();
        engine.asciidoc().converter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(ContentNode node, String transform, Map<Object, Object> opts) {
        this.document = node.getDocument();
        this.page = (Page)Objects.requireNonNull(this.document.getAttribute((Object)"page"), "page is null!");
        String frame = this.frame(node);
        try {
            this.frames.push(frame);
            String string = this.convert(node);
            return string;
        }
        finally {
            this.frames.pop();
        }
    }

    private String convert(ContentNode node) {
        Object templateName;
        if (node == null || node.getNodeName() == null) {
            return "";
        }
        if (node.equals(this.document)) {
            templateName = "document";
        } else if (node.isBlock()) {
            templateName = "block_" + node.getNodeName();
        } else {
            if (node.getNodeName().equals("inline_anchor") && "@@blocklink@@".equals(((PhraseNode)node).getText())) {
                node.getParent().getParent().getAttributes().put("_link", node);
                return "";
            }
            templateName = node.getNodeName();
        }
        Log.debug((String)("Rendering node: " + node), (Object[])new Object[0]);
        try {
            return this.templateEngine.renderString((String)templateName, node);
        }
        catch (RenderingException ex) {
            if (ex instanceof AsciidocRenderingException) {
                throw ex;
            }
            this.ctx.error(new AsciidocRenderingException(ex.getMessage(), this.frames, ex));
            return "";
        }
    }

    public void write(String output, OutputStream out) throws IOException {
        out.write(output.getBytes());
    }

    Deque<String> frames() {
        return this.frames;
    }

    private String frame(ContentNode node) {
        String source;
        String path;
        Cursor location = AsciidocConverter.cursor(node);
        if (location == null) {
            return "\tat ?:?";
        }
        String suffix = (String)this.document.getAttribute((Object)"docfilesuffix");
        if (suffix == null) {
            suffix = ".adoc";
        }
        if ((path = location.getPath()) != null && path.contains(suffix)) {
            Path sourcePath = this.ctx.resolvePath(this.page, path);
            source = this.ctx.sourceDir().relativize(sourcePath).toString();
        } else {
            source = path;
        }
        return String.format("\tat %s:%s", source.replace("\\", "/"), location.getLineNumber());
    }

    private static Cursor cursor(ContentNode node) {
        while (node != null) {
            Cursor sourceLocation;
            if (node instanceof StructuralNode && (sourceLocation = ((StructuralNode)node).getSourceLocation()) != null) {
                return sourceLocation;
            }
            node = node.getParent();
        }
        return null;
    }
}

