/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.maven.sitegen.asciidoctor.Include;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Block {
    private static final Set<String> BLOCK_DELIMITERS = Set.of("====", "----", "....");
    private static final Set<String> BLOCK_INTRODUCERS = Set.of("source", "listing", "example");
    private static final Pattern BLOCK_INTRODUCER_PATTERN = Pattern.compile("\\[([^,\\]]*).*");
    private String blockDecl = null;
    private String delimiter = null;
    private final List<Include> includes = new ArrayList<Include>();
    private final List<String> body = new ArrayList<String>();
    private List<String> preamble = new ArrayList<String>();

    static Block consumeBlock(List<String> content, AtomicInteger lineNumber) {
        Block sb = new Block();
        sb.prepare(content, lineNumber);
        return sb;
    }

    static boolean isBlockStart(String line) {
        Matcher m = BLOCK_INTRODUCER_PATTERN.matcher(line);
        return m.matches() && BLOCK_INTRODUCERS.contains(m.group(1));
    }

    private static boolean isBlockDelimiter(String line) {
        return BLOCK_DELIMITERS.contains(line);
    }

    List<String> asBlockWithNumberedIncludes() {
        return this.asBlock(() -> this.includes.stream().map(Include::asNumberedAsciiDocInclude).collect(Collectors.toList()), this::body);
    }

    List<String> asOriginalBlock() {
        return this.asBlock(this::originalBody);
    }

    List<String> asBracketedBlock() {
        return this.asBlock(this::bracketedBody);
    }

    private List<String> asBlock(Supplier<List<String>> bodyGenerator) {
        return this.asBlock(Collections::emptyList, bodyGenerator);
    }

    private List<String> asBlock(Supplier<List<String>> preambleGenerator, Supplier<List<String>> bodyGenerator) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.blockDecl);
        result.addAll(this.preamble);
        result.addAll((Collection)preambleGenerator.get());
        result.add(this.delimiter);
        result.addAll((Collection)bodyGenerator.get());
        result.add(this.delimiter);
        return result;
    }

    private List<String> body() {
        return this.body;
    }

    private List<String> originalBody() {
        ArrayList<String> result = new ArrayList<String>(this.body);
        for (int i = this.includes.size() - 1; i >= 0; --i) {
            Include ia = this.includes.get(i);
            if (ia.endWithinBlock() >= ia.startWithinBlock()) {
                result.subList(ia.startWithinBlock(), ia.endWithinBlock() + 1).clear();
            }
            if (ia.startWithinBlock() >= result.size()) {
                result.addAll(ia.asAsciiDocInclude());
                continue;
            }
            result.addAll(ia.startWithinBlock(), ia.asAsciiDocInclude());
        }
        return result;
    }

    private List<String> bracketedBody() {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Include.ASCIIDOC_INCLUDE_PATTERN.matcher("");
        for (String bodyLine : this.originalBody()) {
            m.reset(bodyLine);
            if (m.matches()) {
                result.add(String.format("// _include-%s::%s", "start", m.group(1)));
                result.add(bodyLine);
                result.add(String.format("// _include-%s::%s", "end", m.group(1)));
                continue;
            }
            result.add(bodyLine);
        }
        return result;
    }

    List<Include> includes() {
        return this.includes;
    }

    private void prepare(List<String> content, AtomicInteger aLineNumber) {
        this.blockDecl = content.get(aLineNumber.getAndIncrement());
        this.collectPreamble(content, aLineNumber);
        int blockStartLineNumber = this.body.size();
        this.doUntilBlockDelimiter(content, aLineNumber, line -> {
            if (Include.isIncludeStart(line)) {
                aLineNumber.decrementAndGet();
                Include ia = Include.consumeBracketedInclude(content, aLineNumber, this.body, blockStartLineNumber);
                this.includes.add(ia);
                if (ia != null) {
                    this.body.addAll(ia.body());
                }
            } else {
                this.body.add((String)line);
            }
        }, this.delimiter::equals);
    }

    private void collectPreamble(List<String> content, AtomicInteger lineNumber) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList pendingIncludes = new ArrayList();
        Matcher m = Include.INCLUDE_NUMBERED_PATTERN.matcher("");
        this.delimiter = this.doUntilInitialBlockDelimiter(content, lineNumber, line -> {
            m.reset((CharSequence)line);
            if (m.matches()) {
                pendingIncludes.add(line);
            } else {
                result.add((String)line);
            }
        });
        int startOfBlock = lineNumber.get();
        pendingIncludes.forEach(pendingInclude -> this.includes.add(Include.fromNumberedInclude(content, startOfBlock, pendingInclude)));
        this.preamble = result;
    }

    private String doUntilBlockDelimiter(List<String> content, AtomicInteger lineNumber, Consumer<String> lineConsumer, Predicate<String> delimiterDetector) {
        String line;
        while (!delimiterDetector.test(line = content.get(lineNumber.getAndIncrement()))) {
            lineConsumer.accept(line);
        }
        return line;
    }

    private String doUntilInitialBlockDelimiter(List<String> content, AtomicInteger lineNumber, Consumer<String> lineConsumer) {
        return this.doUntilBlockDelimiter(content, lineNumber, lineConsumer, Block::isBlockDelimiter);
    }
}

