/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.common.logging.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.Reader;

public class CardBlockProcessor
extends BlockProcessor {
    public static final String BLOCK_LINK_TEXT = "@@blocklink@@";
    private static final Map<String, Object> CONFIG = CardBlockProcessor.createConfig(":open");

    public CardBlockProcessor() {
        super("CARD", CONFIG);
    }

    public Object process(StructuralNode parent, Reader reader, Map<String, Object> attributes) {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("content_model", "compound");
        Block block = this.createBlock(parent, "card", reader.readLines(), attributes, opts);
        String link = (String)attributes.get("link");
        if (link != null) {
            String linkPhrase;
            String linkType = (String)attributes.get("link-type");
            if (linkType == null || linkType.equals("xref")) {
                linkPhrase = String.format("xref:%s[%s]", link, BLOCK_LINK_TEXT);
            } else if (linkType.equals("url")) {
                linkPhrase = String.format("link:%s[%s]", link, BLOCK_LINK_TEXT);
            } else {
                linkPhrase = null;
                Log.warn((String)link, (Object[])new Object[0]);
            }
            if (linkPhrase != null) {
                this.parseContent((StructuralNode)block, List.of(linkPhrase));
                block.getContent();
            }
        }
        return block;
    }

    private static Map<String, Object> createConfig(String ... blockTypes) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("contexts", Arrays.asList(blockTypes));
        return config;
    }
}

