/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.maven;

import io.helidon.build.common.Maps;
import io.helidon.build.common.maven.plugin.PlexusLoggerHolder;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.Site;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class GenerateMojo
extends AbstractMojo {
    @Component
    private PlexusLoggerHolder plexusLogHolder;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="sitegen.siteOutputDirectory", defaultValue="${project.build.directory}/site", required=true)
    private File siteOutputDirectory;
    @Parameter(property="sitegen.siteSourceDirectory", defaultValue="${project.basedir}/src/main/site", required=true)
    private File siteSourceDirectory;
    @Parameter(property="sitegen.siteConfigFile", required=true)
    private File siteConfigFile;
    @Parameter(property="sitegen.siteGenerateSkip", defaultValue="false")
    private boolean siteGenerateSkip;
    private Site site = null;

    public void execute() throws MojoExecutionException {
        if (this.siteGenerateSkip) {
            this.getLog().info((CharSequence)"processing is skipped.");
            return;
        }
        this.project.addCompileSourceRoot(this.siteSourceDirectory.getAbsolutePath());
        HashMap<String, String> properties = new HashMap<String, String>(Maps.fromProperties((Properties)this.project.getProperties()));
        properties.put("project.groupId", this.project.getGroupId());
        properties.put("project.artifactId", this.project.getArtifactId());
        properties.put("project.version", this.project.getVersion());
        properties.put("project.basedir", this.project.getBasedir().getAbsolutePath());
        try {
            Config config = Config.create(this.siteConfigFile.toPath(), properties);
            this.site = Site.create(config);
            if (this.getLog().isDebugEnabled()) {
                System.setProperty("jruby.cli.verbose", "true");
            }
            this.site.generate(this.siteSourceDirectory.toPath(), this.siteOutputDirectory.toPath());
        }
        catch (RenderingException ex) {
            throw new MojoExecutionException("Rendering error", (Exception)ex);
        }
    }

    public Site getSite() {
        return this.site;
    }
}

