/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Model;
import io.helidon.build.maven.sitegen.models.WebResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class Header
implements Model {
    private final WebResource favicon;
    private final List<WebResource> stylesheets;
    private final List<WebResource> scripts;
    private final Map<String, String> meta;

    private Header(Builder builder) {
        this.favicon = builder.favicon;
        this.stylesheets = builder.stylesheets;
        this.scripts = builder.scripts;
        this.meta = builder.meta;
    }

    public WebResource favicon() {
        return this.favicon;
    }

    public List<WebResource> stylesheets() {
        return this.stylesheets;
    }

    public List<WebResource> scripts() {
        return this.scripts;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "favicon": {
                return this.favicon;
            }
            case "stylesheets": {
                return this.stylesheets;
            }
            case "scripts": {
                return this.scripts;
            }
            case "meta": {
                return this.meta;
            }
        }
        throw new IllegalArgumentException("Unknown attribute: " + attr);
    }

    public String toString() {
        return "Header{favicon=" + this.favicon + ", stylesheets=" + this.stylesheets + ", scripts=" + this.scripts + ", meta=" + this.meta + "}";
    }

    public static Header create(Config config) {
        return Header.builder().config(config).build();
    }

    public static Header create() {
        return Header.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<Header> {
        private WebResource favicon;
        private final List<WebResource> stylesheets = new ArrayList<WebResource>();
        private final List<WebResource> scripts = new ArrayList<WebResource>();
        private final Map<String, String> meta = new HashMap<String, String>();

        public Builder favicon(WebResource favicon) {
            this.favicon = favicon;
            return this;
        }

        public Builder stylesheet(WebResource stylesheet) {
            if (stylesheet != null) {
                this.stylesheets.add(stylesheet);
            }
            return this;
        }

        public Builder stylesheet(Supplier<WebResource> stylesheet) {
            if (stylesheet != null) {
                this.stylesheets.add(stylesheet.get());
            }
            return this;
        }

        public Builder scripts(WebResource script) {
            if (script != null) {
                this.scripts.add(script);
            }
            return this;
        }

        public Builder scripts(Supplier<WebResource> script) {
            if (script != null) {
                this.scripts.add(script.get());
            }
            return this;
        }

        public Builder meta(Map<String, String> meta) {
            if (meta != null) {
                this.meta.putAll(meta);
            }
            return this;
        }

        public Builder config(Config config) {
            this.favicon = config.get("favicon").asOptional().map(WebResource::create).orElse(null);
            config.get("stylesheets").asNodeList().orElseGet(List::of).stream().map(WebResource::create).forEach(this.stylesheets::add);
            config.get("scripts").asNodeList().orElseGet(List::of).stream().map(WebResource::create).forEach(this.scripts::add);
            this.meta.putAll(config.get("meta").asMap(String.class).orElseGet(Map::of));
            return this;
        }

        @Override
        public Header get() {
            return this.build();
        }

        public Header build() {
            return new Header(this);
        }
    }
}

