/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.SourcePath;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.models.Glyph;
import io.helidon.build.maven.sitegen.models.Page;
import io.helidon.build.maven.sitegen.models.SourcePathFilter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Nav
extends SourcePathFilter {
    private final Type type;
    private final String title;
    private final Glyph glyph;
    private final String to;
    private final String source;
    private final String href;
    private final String target;
    private final String dir;
    private final String pathprefix;
    private final List<String> sources;
    private final List<Nav> items;
    private final int depth;

    private Nav(Builder builder) {
        super(builder);
        this.type = Objects.requireNonNull(builder.type, "type is null!");
        this.title = builder.title;
        this.glyph = builder.glyph;
        this.sources = builder.sources;
        this.to = builder.to;
        this.href = builder.href;
        this.target = Objects.requireNonNull(builder.target, "target is null!");
        this.items = builder.items;
        this.depth = builder.maxDepth;
        this.dir = builder.dir;
        this.pathprefix = builder.pathprefix;
        this.source = builder.source;
    }

    public int depth() {
        return this.depth;
    }

    public Type type() {
        return this.type;
    }

    public String title() {
        return this.title;
    }

    public String source() {
        return this.source;
    }

    public List<String> sources() {
        return this.sources;
    }

    public Glyph glyph() {
        return this.glyph;
    }

    public String to() {
        return this.to;
    }

    public String href() {
        return this.href;
    }

    public String target() {
        return this.target;
    }

    public String dir() {
        return this.dir;
    }

    public String pathprefix() {
        return this.pathprefix;
    }

    public List<Nav> items() {
        return this.items;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "type": {
                return this.type.name().toLowerCase();
            }
            case "title": {
                return this.title;
            }
            case "glyph": {
                return this.glyph;
            }
            case "to": {
                return this.to;
            }
            case "href": {
                return this.href;
            }
            case "target": {
                return this.target;
            }
            case "depth": {
                return this.depth;
            }
            case "pathprefix": {
                return this.pathprefix;
            }
            case "items": {
                return this.items;
            }
            case "islink": {
                return this.href != null;
            }
        }
        return super.get(attr);
    }

    public String toString() {
        return "Nav{type=" + this.type + ", title='" + this.title + "'}";
    }

    public List<String> resolveSources(Collection<String> sources) {
        if (this.includes().isEmpty()) {
            return List.of();
        }
        List paths = sources.stream().map(SourcePath::new).collect(Collectors.toList());
        return SourcePath.filter(paths, this.includes(), this.excludes()).stream().map(SourcePath::toString).collect(Collectors.toList());
    }

    public List<Page> resolvePages(Collection<Page> pages) {
        if (this.includes().isEmpty()) {
            return List.of();
        }
        Map paths = pages.stream().collect(Collectors.toMap(Page::sourcePath, Function.identity()));
        List<SourcePath> resolvedPaths = this.resolvePaths(paths.keySet());
        return resolvedPaths.stream().map(s -> Nav.resolvePage(paths, s)).collect(Collectors.toList());
    }

    public static <T> Page resolvePage(Map<T, Page> pages, T source) {
        Page page = pages.get(source);
        if (page == null) {
            throw new IllegalArgumentException("Unable to get page for path: " + source.toString());
        }
        return page;
    }

    public static <T> List<Page> resolvePages(Map<T, Page> pages, List<T> sources) {
        return sources.stream().map(s -> Nav.resolvePage(pages, s)).collect(Collectors.toList());
    }

    public static Nav create(Config config) {
        return Nav.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(Builder parent) {
        return new Builder(parent);
    }

    public static final class Builder
    extends SourcePathFilter.AbstractBuilder<Builder, Nav> {
        private static final String DEFAULT_TARGET = "_blank";
        private String title;
        private Glyph glyph;
        private String to;
        private String href;
        private String target = "_blank";
        private String dir;
        private String pathprefix;
        private String source;
        private Type type;
        private final List<Nav> items = new ArrayList<Nav>();
        private final List<String> sources = new ArrayList<String>();
        private final Builder parent;
        private final int depth;
        private int maxDepth;

        private Builder(Builder parent) {
            this.parent = parent;
            if (parent != null) {
                this.depth = parent.depth + 1;
            } else {
                this.depth = 0;
                this.type = Type.ROOT;
            }
            this.maxDepth = this.depth;
        }

        private String effectiveDir() {
            LinkedList<String> dirs = new LinkedList<String>();
            Builder builder = this;
            while (builder != null) {
                if (builder.dir != null) {
                    dirs.addFirst(builder.dir);
                }
                builder = builder.parent;
            }
            if (dirs.isEmpty()) {
                return null;
            }
            return new SourcePath(dirs).asString(false);
        }

        public int maxDepth() {
            return this.maxDepth;
        }

        public Builder parent() {
            return this.parent;
        }

        public Builder maxDepth(int maxDepth) {
            if (maxDepth > this.maxDepth) {
                this.maxDepth = maxDepth;
            }
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder title(String title) {
            return this.title(title, true);
        }

        public Builder title(String title, boolean overwrite) {
            if (title != null && (this.title == null || overwrite)) {
                this.title = title;
            }
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder sources(List<String> sources) {
            if (sources != null) {
                this.sources.addAll(sources);
            }
            return this;
        }

        public Builder glyph(String type, String value) {
            this.glyph = Glyph.builder().type(type).value(value).build();
            return this;
        }

        public Builder glyph(Glyph glyph) {
            this.glyph = glyph;
            return this;
        }

        public Builder glyph(Supplier<Glyph> supplier) {
            if (supplier != null) {
                this.glyph = supplier.get();
            }
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder href(String href) {
            this.href = href;
            return this;
        }

        public Builder target(String target) {
            if (target != null) {
                this.target = target;
            }
            return this;
        }

        public Builder dir(String dir) {
            if (dir != null && !dir.isEmpty()) {
                this.dir = dir;
            }
            return this;
        }

        public Builder pathprefix(String pathprefix) {
            this.pathprefix = pathprefix;
            return this;
        }

        public Builder item(Builder builder) {
            if (builder != null) {
                this.maxDepth(builder.maxDepth);
                this.items.add(builder.build());
            }
            return this;
        }

        public Builder item(Type type, Consumer<Builder> consumer) {
            Builder builder = Nav.builder(this).type(type);
            consumer.accept(builder);
            return this.item(builder);
        }

        @Override
        public Builder config(Config config) {
            ArrayDeque<Builder> builders = new ArrayDeque<Builder>();
            ArrayDeque<Config> stack = new ArrayDeque<Config>();
            this.applyConfig(config);
            builders.push(this);
            stack.push(config);
            Builder parentBuilder = null;
            while (!stack.isEmpty() && !builders.isEmpty()) {
                List items;
                Config node = (Config)stack.peek();
                Builder builder = (Builder)builders.peek();
                Type nodeType = Type.create(node.get("type"));
                if (nodeType != null && nodeType.is(Type.ROOT, Type.GROUPS, Type.GROUP, Type.MENU) && builder != parentBuilder && !(items = node.get("items").asNodeList().orElseGet(List::of)).isEmpty()) {
                    ListIterator it = items.listIterator(items.size());
                    while (it.hasPrevious()) {
                        Config item = (Config)it.previous();
                        stack.push(item);
                        builders.push(new Builder(builder).applyConfig(item));
                    }
                    continue;
                }
                if (builder.parent != null) {
                    builder.parent.item(builder);
                    builder.parent.maxDepth = builder.maxDepth;
                    parentBuilder = builder.parent;
                    builders.pop();
                }
                stack.pop();
            }
            return this;
        }

        private Builder applyConfig(Config config) {
            this.type = Type.create(config.get("type"));
            this.title = config.get("title").asString().orElse(this.title);
            this.glyph = config.get("glyph").asOptional().map(Glyph::create).orElse(this.glyph);
            this.source = config.get("source").asString().orElse(this.source);
            this.sources.addAll(config.get("sources").asList(String.class).orElse(List.of()));
            this.href = config.get("href").asString().orElse(this.href);
            this.target = config.get("target").asString().orElse(this.target);
            this.dir = config.get("dir").asString().orElse(this.dir);
            this.pathprefix = config.get("pathprefix").asString().orElse(this.pathprefix);
            this.type = config.get("type").asString().map(s -> Type.valueOf(s.toUpperCase())).orElse(this.type);
            super.config(config);
            return this;
        }

        private void require(boolean condition, String name) {
            if (!condition) {
                throw new IllegalArgumentException(String.format("A navigation node of type %s requires '%s'", new Object[]{this.type, name}));
            }
        }

        private void requireNot(boolean condition, String name) {
            if (!condition) {
                throw new IllegalArgumentException(String.format("A navigation node of type %s cannot use '%s'", new Object[]{this.type, name}));
            }
        }

        private static boolean arrayContains(int value, int ... values) {
            for (int v : values) {
                if (value != v) continue;
                return true;
            }
            return false;
        }

        private void require(boolean condition, String name, int value, String expected) {
            if (!condition) {
                throw new IllegalArgumentException(String.format("A navigation node of type %s cannot have %s=%d, expected %s", new Object[]{this.type, name, value, expected}));
            }
        }

        private void requireParent(Type ... types) {
            if (this.parent == null || this.parent.type == null || !this.parent.type.is(types)) {
                throw new IllegalArgumentException(String.format("%s nav node must have a parent of type %s, got %s", new Object[]{this.type, Type.names(types), this.parent != null ? this.parent.type : null}));
            }
        }

        private void validate() {
            if (this.type == null) {
                throw new IllegalArgumentException("Missing navigation node type: " + Type.names());
            }
            switch (this.type) {
                case ROOT: {
                    if (this.parent != null) {
                        throw new IllegalArgumentException("ROOT nav node cannot have a parent");
                    }
                    this.require(this.title != null, "title");
                    this.requireNot(this.href == null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.pathprefix == null, "pathprefix");
                    this.requireNot(this.source == null, "pathprefix");
                    this.requireNot(this.sources.isEmpty(), "sources");
                    this.requireNot(this.includes().isEmpty(), "includes");
                    this.requireNot(this.excludes().isEmpty(), "excludes");
                    break;
                }
                case GROUPS: {
                    this.requireParent(Type.ROOT);
                    this.requireNot(this.title == null, "title");
                    this.requireNot(this.href == null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.pathprefix == null, "pathprefix");
                    this.requireNot(this.source == null, "pathprefix");
                    this.requireNot(this.sources.isEmpty(), "sources");
                    this.requireNot(this.includes().isEmpty(), "includes");
                    this.requireNot(this.excludes().isEmpty(), "excludes");
                    this.require(this.depth == 1, "depth", this.depth, "1");
                    this.require(this.maxDepth <= 4, "max depth", this.maxDepth, "[1, 4]");
                    break;
                }
                case GROUP: {
                    this.requireParent(Type.GROUPS);
                    this.require(this.title != null, "title");
                    this.requireNot(this.href == null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.source == null, "pathprefix");
                    this.requireNot(this.sources.isEmpty(), "sources");
                    this.requireNot(this.includes().isEmpty(), "includes");
                    this.requireNot(this.excludes().isEmpty(), "excludes");
                    this.require(this.depth == 2, "depth", this.depth, "2");
                    this.require(this.maxDepth > 1 && this.maxDepth <= 4, "max depth", this.maxDepth, "[2, 4]");
                    break;
                }
                case MENU: {
                    this.requireParent(Type.GROUP, Type.ROOT);
                    this.require(this.title != null, "title");
                    this.requireNot(this.href == null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.source == null, "pathprefix");
                    this.require(this.depth == 1 || this.depth == 3, "depth", this.depth, "1|3");
                    this.require(this.maxDepth <= 4, "max depth", this.maxDepth, "[1, 4]");
                    break;
                }
                case PAGE: {
                    this.requireParent(Type.GROUP, Type.MENU, Type.ROOT);
                    this.require(this.source != null, "source");
                    this.requireNot(this.pathprefix == null, "pathprefix");
                    this.requireNot(this.href == null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.sources.isEmpty(), "sources");
                    this.requireNot(this.includes().isEmpty(), "includes");
                    this.requireNot(this.excludes().isEmpty(), "excludes");
                    this.requireNot(this.items.isEmpty(), "items");
                    break;
                }
                case LINK: {
                    this.requireParent(Type.GROUP, Type.MENU, Type.ROOT);
                    this.require(this.title != null, "title");
                    this.require(this.href != null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.pathprefix == null, "pathprefix");
                    this.requireNot(this.source == null, "pathprefix");
                    this.requireNot(this.sources.isEmpty(), "sources");
                    this.requireNot(this.includes().isEmpty(), "includes");
                    this.requireNot(this.excludes().isEmpty(), "excludes");
                    this.requireNot(this.items.isEmpty(), "items");
                    break;
                }
                case HEADER: {
                    this.requireParent(Type.ROOT);
                    this.require(this.title != null, "title");
                    this.requireNot(this.href == null, "href");
                    this.requireNot(DEFAULT_TARGET.equals(this.target), "target");
                    this.requireNot(this.pathprefix == null, "pathprefix");
                    this.requireNot(this.source == null, "pathprefix");
                    this.requireNot(this.sources.isEmpty(), "sources");
                    this.requireNot(this.includes().isEmpty(), "includes");
                    this.requireNot(this.excludes().isEmpty(), "excludes");
                    this.requireNot(this.items.isEmpty(), "items");
                    break;
                }
            }
        }

        @Override
        public Nav build() {
            this.dir = this.effectiveDir();
            if ((this.type == Type.GROUP || this.type == Type.MENU) && this.pathprefix == null) {
                if (this.dir != null) {
                    this.pathprefix = "/" + this.dir;
                } else if (this.parent != null) {
                    this.pathprefix = this.parent.pathprefix;
                }
            }
            if (this.source != null) {
                this.source = new SourcePath(this.dir, this.source).asString(false);
            }
            this.validate();
            return new Nav(this);
        }
    }

    public static enum Type {
        ROOT,
        GROUPS,
        GROUP,
        MENU,
        PAGE,
        LINK,
        HEADER;


        boolean is(Type ... types) {
            for (Type type : types) {
                if (this != type) continue;
                return true;
            }
            return false;
        }

        static String names(Type ... types) {
            return Arrays.stream(types).map(Enum::name).collect(Collectors.joining("|"));
        }

        static String names() {
            return Type.names(Type.values());
        }

        static Type create(Config config) {
            return config.asString().map(s -> Type.valueOf(s.toUpperCase())).orElse(null);
        }
    }
}

