/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.SourcePath;
import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Model;
import java.util.Objects;

public class Page
implements Model {
    public static final Page UNRESOLVED = Page.builder().source("unresolved.adoc").target("unresolved").metadata(Metadata.builder().title("Unresolved")).build();
    private final String source;
    private final String target;
    private final Metadata metadata;

    private Page(Builder builder) {
        this.source = Strings.requireValid((String)builder.source, (String)"source is invalid!");
        this.target = Strings.requireValid((String)builder.target, (String)"target is invalid!");
        this.metadata = Objects.requireNonNull(builder.metadata, "metadata is null!");
    }

    public String source() {
        return this.source;
    }

    public SourcePath sourcePath() {
        return new SourcePath(this.source);
    }

    public String target() {
        return this.target;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "source": {
                return this.source;
            }
            case "target": {
                return this.target;
            }
            case "metadata": {
                return this.metadata;
            }
        }
        throw new IllegalStateException("Unknown attribute: " + attr);
    }

    public String toString() {
        return "Page{source='" + this.source + "', target='" + this.target + "', metadata=" + this.metadata + "}";
    }

    public static String removeFileExt(String path) {
        return path.substring(0, path.lastIndexOf("."));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String source;
        private String target;
        private Metadata metadata;

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Metadata.Builder builder) {
            this.metadata = builder.build();
            return this;
        }

        public Page build() {
            return new Page(this);
        }
    }

    public static class Metadata
    implements Model {
        private final String description;
        private final String keywords;
        private final String h1;
        private final String title;
        private final String h1Prefix;

        private Metadata(Builder builder) {
            this.description = builder.description;
            this.keywords = builder.keywords;
            this.h1 = builder.h1;
            this.title = Strings.requireValid((String)builder.docTitle, (String)"docTitle is invalid!");
            this.h1Prefix = builder.h1Prefix;
        }

        public String description() {
            return this.description;
        }

        public String keywords() {
            return this.keywords;
        }

        public String h1() {
            return this.h1;
        }

        public String title() {
            return this.title;
        }

        public String h1Prefix() {
            return this.h1Prefix;
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "description": {
                    return this.description;
                }
                case "keywords": {
                    return this.keywords;
                }
                case "h1": {
                    return this.h1;
                }
                case "title": {
                    return this.title;
                }
                case "h1Prefix": {
                    return this.h1Prefix;
                }
            }
            throw new IllegalStateException("Unknown attribute: " + attr);
        }

        public String toString() {
            return "Metadata{description='" + this.description + "', keywords='" + this.keywords + "', h1='" + this.h1 + "', title='" + this.title + "', h1Prefix='" + this.h1Prefix + "'}";
        }

        public static Metadata create(Config config) {
            return Metadata.builder().config(config).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String description;
            private String keywords;
            private String h1;
            private String h1Prefix;
            private String docTitle;

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder keywords(String keywords) {
                this.keywords = keywords;
                return this;
            }

            public Builder title(String title) {
                this.docTitle = title;
                return this;
            }

            public Builder h1(String h1) {
                this.h1 = h1;
                return this;
            }

            public Builder h1Prefix(String h1Prefix) {
                this.h1Prefix = h1Prefix;
                return this;
            }

            public Builder config(Config config) {
                this.description = config.get("description").asString().orElse(null);
                this.keywords = config.get("keywords").asString().orElse(null);
                this.h1 = config.get("h1").asString().orElse(null);
                this.docTitle = config.get("doctitle").asString().orElse(null);
                this.h1Prefix = config.get("h1-prefix").asString().orElse(null);
                return this;
            }

            public Metadata build() {
                return new Metadata(this);
            }
        }
    }
}

