/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.models.SourcePathFilter;

public final class StaticAsset
extends SourcePathFilter {
    private final String target;

    private StaticAsset(Builder builder) {
        super(builder);
        this.target = Strings.requireValid((String)builder.target, (String)"target is invalid!");
    }

    public String target() {
        return this.target;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "target": {
                return this.target;
            }
        }
        return super.get(attr);
    }

    public String toString() {
        return "StaticAsset{includes='" + this.includes() + "', excludes='" + this.excludes() + "', target='" + this.target + "'}";
    }

    public static StaticAsset create(Config config) {
        return StaticAsset.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SourcePathFilter.AbstractBuilder<Builder, StaticAsset> {
        private String target;

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder config(Config config) {
            this.target = config.get("target").asString().orElse(null);
            super.config(config);
            return this;
        }

        @Override
        public StaticAsset build() {
            return new StaticAsset(this);
        }
    }
}

