/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.snakeyaml;

import io.helidon.codegen.snakeyaml.SnakeYAMLMojo;
import io.helidon.codegen.snakeyaml.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class CodeGenModel {
    private String generatedPackageName;
    private String generatedClassName;
    private Collection<Type> types;
    private Set<SnakeYAMLMojo.Import> imports;
    private String interfacePrefix;
    private String implementationPrefix;

    CodeGenModel(String generatedPackageName, String generatedClassName, Collection<Type> types, Set<SnakeYAMLMojo.Import> imports, String interfacePrefix, String implementationPrefix) {
        this.generatedClassName = generatedClassName;
        this.generatedPackageName = generatedPackageName;
        this.types = types;
        this.imports = imports;
        this.interfacePrefix = interfacePrefix;
        this.implementationPrefix = implementationPrefix;
    }

    String generatedPackageName() {
        return this.generatedPackageName;
    }

    String generatedClassName() {
        return this.generatedClassName;
    }

    Collection<Type> typesToAugment() {
        return this.types.stream().filter(t -> t.implementationType() != null).collect(Collectors.toList());
    }

    List<SnakeYAMLMojo.Import> javaImports() {
        return this.filteredImports("java.");
    }

    List<SnakeYAMLMojo.Import> implImports() {
        return this.filteredImports(this.implementationPrefix);
    }

    List<SnakeYAMLMojo.Import> openAPIImports() {
        return this.filteredImports(this.interfacePrefix);
    }

    private List<SnakeYAMLMojo.Import> filteredImports(String namePrefix) {
        return this.imports.stream().filter(i -> i.name().startsWith(namePrefix)).sorted().collect(Collectors.toList());
    }
}

