/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.concurrency.limits.FixedLimitConfig;
import io.helidon.common.concurrency.limits.IgnoreTaskException;
import io.helidon.common.concurrency.limits.Limit;
import io.helidon.common.concurrency.limits.LimitAlgorithm;
import io.helidon.common.concurrency.limits.LimitException;
import io.helidon.common.concurrency.limits.NoopSemaphore;
import io.helidon.common.concurrency.limits.SemaphoreLimit;
import io.helidon.common.config.Config;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=FixedLimitConfig.class)
public class FixedLimit
implements Limit,
SemaphoreLimit,
RuntimeType.Api<FixedLimitConfig> {
    public static final int DEFAULT_LIMIT = 0;
    public static final int DEFAULT_QUEUE_LENGTH = 0;
    public static final String DEFAULT_QUEUE_TIMEOUT_DURATION = "PT1S";
    static final String TYPE = "fixed";
    private final FixedLimitConfig config;
    private final LimiterHandler handler;
    private final int initialPermits;

    private FixedLimit(FixedLimitConfig config) {
        this.config = config;
        if (config.permits() == 0 && config.semaphore().isEmpty()) {
            this.handler = new NoOpSemaphoreHandler();
            this.initialPermits = 0;
        } else {
            Semaphore semaphore = config.semaphore().orElseGet(() -> new Semaphore(config.permits(), config.fair()));
            this.initialPermits = semaphore.availablePermits();
            this.handler = config.queueLength() == 0 ? new RealSemaphoreHandler(semaphore) : new QueuedSemaphoreHandler(semaphore, config.queueLength(), config.queueTimeout());
        }
    }

    public static FixedLimitConfig.Builder builder() {
        return FixedLimitConfig.builder();
    }

    public static FixedLimit create() {
        return FixedLimit.builder().build();
    }

    public static FixedLimit create(Semaphore semaphore) {
        return ((FixedLimitConfig.Builder)FixedLimit.builder().semaphore(semaphore)).build();
    }

    public static FixedLimit create(Config config) {
        return ((FixedLimitConfig.Builder)FixedLimit.builder().config(config)).build();
    }

    public static FixedLimit create(FixedLimitConfig config) {
        return new FixedLimit(config);
    }

    public static FixedLimit create(Consumer<FixedLimitConfig.Builder> consumer) {
        return ((FixedLimitConfig.Builder)FixedLimit.builder().update(consumer)).build();
    }

    @Override
    public <T> T invoke(Callable<T> callable) throws Exception {
        return this.handler.invoke(callable);
    }

    @Override
    public void invoke(Runnable runnable) throws Exception {
        this.handler.invoke(runnable);
    }

    @Override
    public Optional<LimitAlgorithm.Token> tryAcquire(boolean wait) {
        return this.handler.tryAcquire(wait);
    }

    @Override
    public Semaphore semaphore() {
        return this.handler.semaphore();
    }

    public FixedLimitConfig prototype() {
        return this.config;
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return TYPE;
    }

    @Override
    public Limit copy() {
        if (this.config.semaphore().isPresent()) {
            Semaphore semaphore = this.config.semaphore().get();
            return ((FixedLimitConfig.Builder)((FixedLimitConfig.Builder)FixedLimitConfig.builder().from(this.config)).semaphore(new Semaphore(this.initialPermits, semaphore.isFair()))).build();
        }
        return (Limit)this.config.build();
    }

    private static class NoOpSemaphoreHandler
    implements LimiterHandler {
        private static final LimitAlgorithm.Token TOKEN = new LimitAlgorithm.Token(){

            @Override
            public void dropped() {
            }

            @Override
            public void ignore() {
            }

            @Override
            public void success() {
            }
        };

        private NoOpSemaphoreHandler() {
        }

        @Override
        public <T> T invoke(Callable<T> callable) throws Exception {
            try {
                return callable.call();
            }
            catch (IgnoreTaskException e) {
                return e.handle();
            }
        }

        @Override
        public void invoke(Runnable runnable) {
            runnable.run();
        }

        @Override
        public Optional<LimitAlgorithm.Token> tryAcquire(boolean wait) {
            return Optional.of(TOKEN);
        }

        @Override
        public Semaphore semaphore() {
            return NoopSemaphore.INSTANCE;
        }
    }

    private static interface LimiterHandler
    extends SemaphoreLimit,
    LimitAlgorithm {
    }

    private static class RealSemaphoreHandler
    implements LimiterHandler {
        private final Semaphore semaphore;

        private RealSemaphoreHandler(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T invoke(Callable<T> callable) throws Exception {
            if (this.semaphore.tryAcquire()) {
                try {
                    T t = callable.call();
                    return t;
                }
                catch (IgnoreTaskException e) {
                    Object t = e.handle();
                    return t;
                }
                finally {
                    this.semaphore.release();
                }
            }
            throw new LimitException("No more permits available for the semaphore");
        }

        @Override
        public void invoke(Runnable runnable) throws Exception {
            if (this.semaphore.tryAcquire()) {
                try {
                    runnable.run();
                }
                catch (IgnoreTaskException e) {
                    e.handle();
                }
                finally {
                    this.semaphore.release();
                }
            } else {
                throw new LimitException("No more permits available for the semaphore");
            }
        }

        @Override
        public Optional<LimitAlgorithm.Token> tryAcquire(boolean wait) {
            if (!this.semaphore.tryAcquire()) {
                return Optional.empty();
            }
            return Optional.of(new SemaphoreToken(this.semaphore));
        }

        @Override
        public Semaphore semaphore() {
            return this.semaphore;
        }
    }

    private static class QueuedSemaphoreHandler
    implements LimiterHandler {
        private final Semaphore semaphore;
        private final int queueLength;
        private final long timeoutMillis;

        private QueuedSemaphoreHandler(Semaphore semaphore, int queueLength, Duration queueTimeout) {
            this.semaphore = semaphore;
            this.queueLength = queueLength;
            this.timeoutMillis = queueTimeout.toMillis();
        }

        @Override
        public Optional<LimitAlgorithm.Token> tryAcquire(boolean wait) {
            if (this.semaphore.getQueueLength() >= this.queueLength) {
                return Optional.empty();
            }
            try {
                if (wait ? !this.semaphore.tryAcquire(this.timeoutMillis, TimeUnit.MILLISECONDS) : !this.semaphore.tryAcquire()) {
                    return Optional.empty();
                }
            }
            catch (InterruptedException e) {
                return Optional.empty();
            }
            return Optional.of(new SemaphoreToken(this.semaphore));
        }

        @Override
        public Semaphore semaphore() {
            return this.semaphore;
        }
    }

    private static class SemaphoreToken
    implements LimitAlgorithm.Token {
        private final Semaphore semaphore;

        private SemaphoreToken(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        @Override
        public void dropped() {
            this.semaphore.release();
        }

        @Override
        public void ignore() {
            this.semaphore.release();
        }

        @Override
        public void success() {
            this.semaphore.release();
        }
    }
}

