/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.concurrency.limits.AimdLimit;
import io.helidon.common.concurrency.limits.AimdLimitConfigBlueprint;
import io.helidon.common.config.Config;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.concurrency.limits.AimdLimitConfigBlueprint")
public interface AimdLimitConfig
extends AimdLimitConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AimdLimitConfig instance) {
        return (Builder)AimdLimitConfig.builder().from(instance);
    }

    public static AimdLimitConfig create(Config config) {
        return ((Builder)AimdLimitConfig.builder().config(config)).buildPrototype();
    }

    public static AimdLimitConfig create() {
        return AimdLimitConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, AimdLimitConfig>
    implements io.helidon.common.Builder<Builder, AimdLimit> {
        private Builder() {
        }

        public AimdLimitConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.AimdLimitConfigImpl(this);
        }

        public AimdLimit build() {
            return AimdLimit.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends AimdLimitConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private double backoffRatio = 0.9;
        private Duration timeout = Duration.parse("PT5S");
        private int initialLimit = 20;
        private int maxLimit = 200;
        private int minLimit = 20;
        private String name = "aimd";
        private Supplier<Long> clock;

        protected BuilderBase() {
        }

        public BUILDER from(AimdLimitConfig prototype) {
            this.backoffRatio(prototype.backoffRatio());
            this.initialLimit(prototype.initialLimit());
            this.maxLimit(prototype.maxLimit());
            this.minLimit(prototype.minLimit());
            this.timeout(prototype.timeout());
            this.clock(prototype.clock());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.backoffRatio(builder.backoffRatio());
            this.initialLimit(builder.initialLimit());
            this.maxLimit(builder.maxLimit());
            this.minLimit(builder.minLimit());
            this.timeout(builder.timeout());
            builder.clock().ifPresent(this::clock);
            this.name(builder.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("backoff-ratio").as(Double.class).ifPresent(this::backoffRatio);
            config.get("initial-limit").as(Integer.class).ifPresent(this::initialLimit);
            config.get("max-limit").as(Integer.class).ifPresent(this::maxLimit);
            config.get("min-limit").as(Integer.class).ifPresent(this::minLimit);
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER backoffRatio(double backoffRatio) {
            this.backoffRatio = backoffRatio;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxLimit(int maxLimit) {
            this.maxLimit = maxLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minLimit(int minLimit) {
            this.minLimit = minLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearClock() {
            this.clock = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clock(Supplier<Long> clock) {
            Objects.requireNonNull(clock);
            this.clock = clock;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public double backoffRatio() {
            return this.backoffRatio;
        }

        public int initialLimit() {
            return this.initialLimit;
        }

        public int maxLimit() {
            return this.maxLimit;
        }

        public int minLimit() {
            return this.minLimit;
        }

        public Duration timeout() {
            return this.timeout;
        }

        public Optional<Supplier<Long>> clock() {
            return Optional.ofNullable(this.clock);
        }

        public String name() {
            return this.name;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "AimdLimitConfigBuilder{backoffRatio=" + this.backoffRatio + ",initialLimit=" + this.initialLimit + ",maxLimit=" + this.maxLimit + ",minLimit=" + this.minLimit + ",timeout=" + String.valueOf(this.timeout) + ",clock=" + String.valueOf(this.clock) + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER clock(Optional<Supplier<Long>> clock) {
            Objects.requireNonNull(clock);
            this.clock = clock.map(Supplier.class::cast).orElse(this.clock);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class AimdLimitConfigImpl
        implements AimdLimitConfig,
        Supplier<AimdLimit> {
            private final double backoffRatio;
            private final Duration timeout;
            private final int initialLimit;
            private final int maxLimit;
            private final int minLimit;
            private final Optional<Supplier<Long>> clock;
            private final String name;

            protected AimdLimitConfigImpl(BuilderBase<?, ?> builder) {
                this.backoffRatio = builder.backoffRatio();
                this.initialLimit = builder.initialLimit();
                this.maxLimit = builder.maxLimit();
                this.minLimit = builder.minLimit();
                this.timeout = builder.timeout();
                this.clock = builder.clock();
                this.name = builder.name();
            }

            public AimdLimit build() {
                return AimdLimit.create(this);
            }

            @Override
            public AimdLimit get() {
                return this.build();
            }

            @Override
            public double backoffRatio() {
                return this.backoffRatio;
            }

            @Override
            public int initialLimit() {
                return this.initialLimit;
            }

            @Override
            public int maxLimit() {
                return this.maxLimit;
            }

            @Override
            public int minLimit() {
                return this.minLimit;
            }

            @Override
            public Duration timeout() {
                return this.timeout;
            }

            @Override
            public Optional<Supplier<Long>> clock() {
                return this.clock;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                return "AimdLimitConfig{backoffRatio=" + this.backoffRatio + ",initialLimit=" + this.initialLimit + ",maxLimit=" + this.maxLimit + ",minLimit=" + this.minLimit + ",timeout=" + String.valueOf(this.timeout) + ",clock=" + String.valueOf(this.clock) + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AimdLimitConfig)) {
                    return false;
                }
                AimdLimitConfig other = (AimdLimitConfig)o;
                return this.backoffRatio == other.backoffRatio() && this.initialLimit == other.initialLimit() && this.maxLimit == other.maxLimit() && this.minLimit == other.minLimit() && Objects.equals(this.timeout, other.timeout()) && Objects.equals(this.clock, other.clock()) && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.backoffRatio, this.initialLimit, this.maxLimit, this.minLimit, this.timeout, this.clock, this.name);
            }
        }
    }
}

