/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features;

import io.helidon.common.features.FeatureDescriptor;
import io.helidon.common.features.api.HelidonFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

final class FeatureCatalog {
    private static final System.Logger LOGGER = System.getLogger(FeatureCatalog.class.getName());
    private static final HelidonFlavor[] NO_FLAVORS = new HelidonFlavor[0];

    private FeatureCatalog() {
    }

    static List<FeatureDescriptor> features(ClassLoader classLoader) {
        LinkedList<FeatureDescriptor> features = new LinkedList<FeatureDescriptor>();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/helidon/feature-metadata.properties");
            while (resources.hasMoreElements()) {
                String aotDescription;
                URL url = resources.nextElement();
                Properties props = new Properties();
                try (InputStream in = url.openStream();){
                    props.load(in);
                }
                String module = props.getProperty("m");
                if (module == null) {
                    LOGGER.log(System.Logger.Level.WARNING, "Got module descriptor with no module name. Available properties: " + String.valueOf(props));
                    continue;
                }
                FeatureDescriptor.Builder builder = FeatureDescriptor.builder();
                builder.name(props.getProperty("n", module)).module(module).description(props.getProperty("d", "")).path(FeatureCatalog.toArray(props.getProperty("p"), props.getProperty("n"))).flavor(FeatureCatalog.toFlavor(module, props.getProperty("in"), true)).notFlavor(FeatureCatalog.toFlavor(module, props.getProperty("not"), false)).since(props.getProperty("s", "1.0.0"));
                if ("true".equals(props.getProperty("pr"))) {
                    builder.preview(true);
                }
                if ("false".equals(props.getProperty("aot"))) {
                    builder.nativeSupported(false);
                }
                if ("true".equals(props.getProperty("i"))) {
                    builder.incubating(true);
                }
                if ("true".equals(props.getProperty("dep"))) {
                    builder.deprecated(true);
                    builder.deprecatedSince(props.getProperty("deps", "4.0.1"));
                }
                if ((aotDescription = props.getProperty("aotd")) != null) {
                    builder.nativeDescription(aotDescription);
                }
                features.add(builder.build());
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Could not discover Helidon features", (Throwable)e);
        }
        Collections.sort(features);
        return features;
    }

    private static HelidonFlavor[] toFlavor(String module, String flavorString, boolean useAllIfMissing) {
        if (flavorString == null || flavorString.isBlank()) {
            return useAllIfMissing ? HelidonFlavor.values() : NO_FLAVORS;
        }
        String[] values = FeatureCatalog.toArray(flavorString, flavorString);
        HelidonFlavor[] result = new HelidonFlavor[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                result[i] = HelidonFlavor.valueOf((String)values[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Invalid flavor defined: " + values[i] + " in module " + module);
                return NO_FLAVORS;
            }
        }
        return result;
    }

    private static String[] toArray(String property, String defaultValue) {
        String toProcess = property;
        if (property == null) {
            toProcess = defaultValue;
        }
        if (toProcess == null) {
            return new String[0];
        }
        return toProcess.split(",");
    }
}

