/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import java.nio.charset.Charset;

public class LazyString {
    private final byte[] buffer;
    private final int offset;
    private final int length;
    private final Charset charset;
    private String stringValue;
    private String owsLessValue;

    public LazyString(byte[] buffer, int offset, int length, Charset charset) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.charset = charset;
    }

    public LazyString(byte[] buffer, Charset charset) {
        this.buffer = buffer;
        this.offset = 0;
        this.length = buffer.length;
        this.charset = charset;
    }

    public String stripOws() {
        if (this.owsLessValue == null) {
            int i;
            int newOffset = this.offset;
            int newLength = this.length;
            for (i = this.offset; i < this.offset + this.length && this.isOws(this.buffer[i]); ++i) {
                newOffset = i + 1;
                newLength = this.length - (newOffset - this.offset);
            }
            for (i = this.offset + this.length - 1; i > newOffset && this.isOws(this.buffer[i]); --i) {
                --newLength;
            }
            newLength = Math.max(newLength, 0);
            this.owsLessValue = new String(this.buffer, newOffset, newLength, this.charset);
        }
        return this.owsLessValue;
    }

    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = new String(this.buffer, this.offset, this.length, this.charset);
        }
        return this.stringValue;
    }

    private boolean isOws(byte aByte) {
        return switch (aByte) {
            case 9, 32 -> true;
            default -> false;
        };
    }
}

