/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.BufferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

class GrowingBufferData
implements BufferData {
    private byte[] bytes;
    private int length;
    private int writePosition;
    private int readPosition;

    GrowingBufferData(int initialLength) {
        int usedInitial = Math.max(initialLength, 256);
        this.bytes = new byte[usedInitial];
        this.length = 0;
    }

    public boolean ready() {
        return this.writePosition > this.readPosition;
    }

    @Override
    public GrowingBufferData reset() {
        this.writePosition = 0;
        this.readPosition = 0;
        return this;
    }

    @Override
    public BufferData rewind() {
        this.readPosition = 0;
        return this;
    }

    @Override
    public BufferData clear() {
        this.reset();
        this.length = 0;
        return this;
    }

    @Override
    public void writeTo(OutputStream out) {
        try {
            out.write(this.bytes, this.readPosition, this.writePosition - this.readPosition);
            this.readPosition = this.writePosition;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int readFrom(InputStream in) {
        try {
            int read = in.read(this.bytes, this.writePosition, this.bytes.length - this.writePosition);
            if (read > 0) {
                this.writePosition += read;
            }
            return read;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int read() {
        if (this.readPosition >= this.writePosition) {
            throw new ArrayIndexOutOfBoundsException("This buffer has " + this.length + " bytes, requested to read at " + this.readPosition);
        }
        return this.bytes[this.readPosition++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int position, int length) {
        int available = this.writePosition - this.readPosition;
        int toRead = Math.min(length, available);
        System.arraycopy(this.bytes, this.readPosition, bytes, position, toRead);
        this.readPosition += toRead;
        return toRead;
    }

    @Override
    public String readString(int length, Charset charset) {
        String result = new String(this.bytes, this.readPosition, length, charset);
        this.readPosition += length;
        return result;
    }

    @Override
    public boolean consumed() {
        return this.readPosition == this.writePosition;
    }

    @Override
    public GrowingBufferData write(int value) {
        this.ensureSize(1);
        this.bytes[this.writePosition++] = (byte)value;
        this.length = Math.max(this.length, this.writePosition);
        return this;
    }

    @Override
    public int writeTo(ByteBuffer writeBuffer, int limit) {
        int toWrite = Math.min(writeBuffer.capacity(), this.length - this.readPosition);
        if ((toWrite = Math.min(toWrite, limit)) == 0) {
            return 0;
        }
        writeBuffer.put(this.bytes, this.readPosition, toWrite);
        this.readPosition += toWrite;
        return toWrite;
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        this.ensureSize(length);
        System.arraycopy(bytes, offset, this.bytes, this.writePosition, length);
        this.writePosition += length;
        this.length = Math.max(this.length, this.writePosition);
    }

    @Override
    public void write(BufferData toWrite) {
        this.ensureSize(toWrite.available());
        byte[] buffer = new byte[toWrite.available()];
        int read = toWrite.read(buffer);
        System.arraycopy(buffer, 0, this.bytes, this.writePosition, read);
        this.writePosition += read;
    }

    @Override
    public void write(BufferData toWrite, int length) {
        this.ensureSize(length);
        byte[] buffer = new byte[length];
        int read = toWrite.read(buffer);
        System.arraycopy(buffer, 0, this.bytes, this.writePosition, read);
        this.writePosition += read;
    }

    @Override
    public String debugDataBinary() {
        return BufferUtil.debugDataBinary(this.bytes, 0, this.writePosition);
    }

    @Override
    public String debugDataHex(boolean fullBuffer) {
        return BufferUtil.debugDataHex(this.bytes, fullBuffer ? 0 : this.readPosition, this.writePosition);
    }

    @Override
    public int available() {
        return this.writePosition - this.readPosition;
    }

    @Override
    public void skip(int length) {
        this.readPosition += length;
    }

    @Override
    public int indexOf(byte aByte) {
        for (int i = this.readPosition; i < this.readPosition + this.available(); ++i) {
            if (this.bytes[i] != aByte) continue;
            return i - this.readPosition;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte aByte, int length) {
        for (int i = length - 1; i >= this.readPosition; --i) {
            byte b = this.bytes[i];
            if (b != aByte) continue;
            return i - this.readPosition;
        }
        return -1;
    }

    @Override
    public BufferData trim(int x) {
        if (this.available() < x) {
            throw new IllegalArgumentException("Trimming more bytes than available");
        }
        this.writePosition -= x;
        this.length -= x;
        return this;
    }

    @Override
    public int capacity() {
        return this.length - this.writePosition;
    }

    @Override
    public int get(int index) {
        return this.bytes[this.readPosition + index];
    }

    public String toString() {
        return "grow: l=" + this.length + ", r=" + this.readPosition + ", w=" + this.writePosition + ", c=" + this.bytes.length;
    }

    byte[] bytes() {
        return Arrays.copyOfRange(this.bytes, 0, this.length);
    }

    private void ensureSize(int i) {
        if (this.bytes.length > this.writePosition + i) {
            return;
        }
        byte[] current = this.bytes;
        int currentLength = current.length;
        int newLength = currentLength * 2;
        if ((newLength = Math.max(newLength, this.writePosition + i)) < currentLength) {
            throw new IllegalStateException("Growing buffer too big, cannot increase size");
        }
        this.bytes = new byte[newLength];
        System.arraycopy(current, 0, this.bytes, 0, this.length);
    }
}

