/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import io.helidon.common.buffers.BufferUtil;
import io.helidon.common.buffers.CompositeArrayBufferData;
import io.helidon.common.buffers.CompositeBufferData;
import io.helidon.common.buffers.CompositeListBufferData;
import io.helidon.common.buffers.FixedBufferData;
import io.helidon.common.buffers.GrowingBufferData;
import io.helidon.common.buffers.ReadOnlyArrayData;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public interface BufferData {
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static BufferData create(int length) {
        return new FixedBufferData(length);
    }

    public static BufferData create(byte[] bytes) {
        return new FixedBufferData(bytes);
    }

    public static BufferData create(byte[] bytes, int position, int length) {
        return new FixedBufferData(bytes, position, length);
    }

    public static BufferData createReadOnly(byte[] bytes, int offset, int length) {
        return new ReadOnlyArrayData(bytes, offset, length);
    }

    public static BufferData growing(int initialLength) {
        return new GrowingBufferData(initialLength);
    }

    public static BufferData create(BufferData ... data) {
        if (data.length == 1) {
            return data[0];
        }
        if (data.length == 0) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return new CompositeArrayBufferData(data);
    }

    public static CompositeBufferData createComposite() {
        return new CompositeListBufferData();
    }

    public static CompositeBufferData createComposite(BufferData first) {
        return new CompositeListBufferData(first);
    }

    public static BufferData create(List<BufferData> data) {
        if (data.size() == 1) {
            return data.iterator().next();
        }
        if (data.isEmpty()) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return new CompositeListBufferData(data);
    }

    public static String toBinaryString(int value) {
        return BufferUtil.toBinaryString(value);
    }

    public static int toInt31(int value) {
        return value & Integer.MAX_VALUE;
    }

    public static BufferData empty() {
        return BufferUtil.EMPTY_BUFFER;
    }

    public static BufferData create(String stringValue) {
        Objects.requireNonNull(stringValue);
        if (stringValue.isEmpty()) {
            return BufferData.empty();
        }
        return BufferData.create(stringValue.getBytes(StandardCharsets.UTF_8));
    }

    public BufferData reset();

    public BufferData rewind();

    public BufferData clear();

    public void writeTo(OutputStream var1);

    public int readFrom(InputStream var1);

    public int read();

    default public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] var1, int var2, int var3);

    default public void forEach(int length, Function<Byte, Boolean> consumer) {
        for (int i = 0; i < length && consumer.apply((byte)this.read()).booleanValue(); ++i) {
        }
    }

    default public String readString(int length) {
        return this.readString(length, StandardCharsets.UTF_8);
    }

    public String readString(int var1, Charset var2);

    public boolean consumed();

    default public int readInt16() {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + ch2;
    }

    default public int readInt24() {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        return (ch1 << 16) + (ch2 << 8) + ch3;
    }

    default public int readInt32() {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    default public long readUnsignedInt32() {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return ((long)ch1 << 24) + ((long)ch2 << 16) + ((long)ch3 << 8) + (long)ch4;
    }

    default public long readLong() {
        return ((long)this.read() << 56) + ((long)(this.read() & 0xFF) << 48) + ((long)(this.read() & 0xFF) << 40) + ((long)(this.read() & 0xFF) << 32) + ((long)(this.read() & 0xFF) << 24) + (long)((this.read() & 0xFF) << 16) + (long)((this.read() & 0xFF) << 8) + (long)(this.read() & 0xFF);
    }

    default public BufferData writeInt8(int number) {
        return this.write(number);
    }

    default public BufferData writeInt16(int number) {
        this.write((byte)(number >>> 8));
        this.write((byte)number);
        return this;
    }

    default public BufferData writeInt24(int number) {
        this.write((byte)(number >>> 16));
        this.write((byte)(number >>> 8));
        this.write((byte)number);
        return this;
    }

    default public BufferData writeInt32(int number) {
        this.write((byte)(number >>> 24));
        this.write((byte)(number >>> 16));
        this.write((byte)(number >>> 8));
        this.write((byte)number);
        return this;
    }

    default public BufferData writeUnsignedInt32(long number) {
        this.write((byte)(number >>> 24));
        this.write((byte)(number >>> 16));
        this.write((byte)(number >>> 8));
        this.write((byte)number);
        return this;
    }

    public BufferData write(int var1);

    public int writeTo(ByteBuffer var1, int var2);

    default public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] var1, int var2, int var3);

    default public void write(BufferData toWrite) {
        this.write(toWrite, toWrite.available());
    }

    public void write(BufferData var1, int var2);

    default public int readHpackInt(int originalValue, int bitsOfPrefix) {
        int next;
        int value = originalValue & 255 >> 8 - bitsOfPrefix;
        int max = (1 << bitsOfPrefix) - 1;
        if (value < max) {
            return value;
        }
        int shiftBy = 0;
        do {
            next = this.read();
            value += (next & 0x7F) << shiftBy;
            shiftBy += 7;
        } while ((next & 0x80) != 0);
        return value;
    }

    default public BufferData writeHpackInt(int value, int prefixedInt, int bitPrefix) {
        int prefixedValue = prefixedInt & ~(255 >> 8 - bitPrefix);
        int max = (1 << bitPrefix) - 1;
        if (value < max) {
            this.write(value | prefixedValue);
            return this;
        }
        this.write(max | prefixedValue);
        int remainingValue = value - max;
        while (true) {
            if (remainingValue < 128) {
                this.write(remainingValue);
                return this;
            }
            int toWrite = remainingValue & 0x7F | 0x80;
            this.write(toWrite);
            remainingValue >>= 7;
        }
    }

    public String debugDataBinary();

    public String debugDataHex(boolean var1);

    default public String debugDataHex() {
        return this.debugDataHex(true);
    }

    default public BufferData copy() {
        byte[] copy = new byte[this.available()];
        this.read(copy, 0, this.available());
        return BufferData.create(copy);
    }

    public int available();

    public void skip(int var1);

    public int indexOf(byte var1);

    default public int lastIndexOf(byte aByte) {
        return this.lastIndexOf(aByte, this.available());
    }

    public int lastIndexOf(byte var1, int var2);

    public BufferData trim(int var1);

    public int capacity();

    default public void writeAscii(String text) {
        this.write(text.getBytes(StandardCharsets.US_ASCII));
    }

    public int get(int var1);

    default public byte[] readBytes() {
        byte[] bytes = new byte[this.available()];
        this.read(bytes);
        return bytes;
    }

    default public InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int read() {
                return BufferData.this.available() > 0 ? BufferData.this.read() : -1;
            }
        };
    }
}

