/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.config;

import io.helidon.common.config.ConfigException;
import io.helidon.common.config.ConfigValue;
import io.helidon.common.config.EmptyConfig;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface Config {
    public static Config empty() {
        return EmptyConfig.EMPTY;
    }

    public Key key();

    default public String name() {
        return this.key().name();
    }

    public Config get(String var1) throws ConfigException;

    public Config root();

    default public Config get(Key key) {
        return this.get(key.name());
    }

    public Config detach() throws ConfigException;

    public boolean exists();

    public boolean isLeaf();

    public boolean isObject();

    public boolean isList();

    public boolean hasValue();

    public <T> ConfigValue<T> as(Class<T> var1);

    public <T> ConfigValue<T> map(Function<Config, T> var1);

    public <T> ConfigValue<List<T>> asList(Class<T> var1) throws ConfigException;

    public <T> ConfigValue<List<T>> mapList(Function<Config, T> var1) throws ConfigException;

    public <C extends Config> ConfigValue<List<C>> asNodeList() throws ConfigException;

    public ConfigValue<Map<String, String>> asMap() throws ConfigException;

    default public ConfigValue<? extends Config> asNode() {
        return this.as(Config.class);
    }

    default public ConfigValue<String> asString() {
        return this.as(String.class);
    }

    default public ConfigValue<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    default public ConfigValue<Integer> asInt() {
        return this.as(Integer.class);
    }

    default public ConfigValue<Long> asLong() {
        return this.as(Long.class);
    }

    default public ConfigValue<Double> asDouble() {
        return this.as(Double.class);
    }

    public static interface Key
    extends Comparable<Key> {
        public static String escapeName(String name) {
            char[] chars;
            if (!name.contains("~") && !name.contains(".")) {
                return name;
            }
            StringBuilder sb = new StringBuilder();
            for (char ch : chars = name.toCharArray()) {
                if (ch == '~') {
                    sb.append("~0");
                    continue;
                }
                if (ch == '.') {
                    sb.append("~1");
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static String unescapeName(String escapedName) {
            return escapedName.replaceAll("~1", ".").replaceAll("~0", "~");
        }

        public Key parent() throws ConfigException;

        public boolean isRoot();

        public String name();

        public String toString();

        public Key child(Key var1);
    }
}

