/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceException;
import io.helidon.common.configurable.ResourceImpl;
import io.helidon.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;

final class ResourceUtil {
    private static final int DEFAULT_PROXY_PORT = 80;

    private ResourceUtil() {
    }

    static Resource from(InputStream inputStream, String description, Resource.Source resourceSource) {
        return new ResourceImpl(resourceSource, description, inputStream);
    }

    static InputStream toIs(Path fsPath) {
        Objects.requireNonNull(fsPath, "Resource file system path must not be null");
        try {
            return Files.newInputStream(fsPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ResourceException("Resource on path: " + fsPath.toAbsolutePath() + " does not exist", e);
        }
    }

    static InputStream toIs(String resPath) {
        Objects.requireNonNull(resPath, "Resource path must not be null");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resPath);
        Objects.requireNonNull(is, "Resource path does not exist: " + resPath);
        return is;
    }

    static InputStream toIs(URI uri) {
        try {
            return uri.toURL().openStream();
        }
        catch (IOException e) {
            throw new ResourceException("Failed to open stream to uri: " + uri, e);
        }
    }

    static InputStream toIs(URI uri, Proxy proxy) {
        try {
            return uri.toURL().openConnection(proxy).getInputStream();
        }
        catch (IOException e) {
            throw new ResourceException("Failed to open stream to uri: " + uri, e);
        }
    }

    static Optional<Resource> fromConfigPath(Config config, String keyPrefix) {
        return config.get(keyPrefix + "-path").asString().map(x$0 -> Paths.get(x$0, new String[0])).map(Resource::create);
    }

    static Optional<Resource> fromConfigB64Content(Config config, String keyPrefix) {
        return config.get(keyPrefix + "-content").asString().map(Base64.getDecoder()::decode).map(content -> Resource.create("config:" + keyPrefix + "-content-b64", content));
    }

    static Optional<Resource> fromConfigContent(Config config, String keyPrefix) {
        return config.get(keyPrefix + "-content-plain").asString().map(content -> Resource.create("config:" + keyPrefix + "-content", content));
    }

    static Optional<Resource> fromConfigUrl(Config config, String keyPrefix) {
        return config.get(keyPrefix + "-url").as(URI.class).map(uri -> config.get("proxy-host").asString().map(proxyHost -> {
            if (((Boolean)config.get(keyPrefix + "-use-proxy").asBoolean().orElse((Object)true)).booleanValue()) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)proxyHost, (int)((Integer)config.get("proxy-port").asInt().orElse((Object)80))));
                return Resource.create(uri, proxy);
            }
            return Resource.create(uri);
        }).orElseGet(() -> Resource.create(uri)));
    }

    static Optional<Resource> fromConfigResourcePath(Config config, String keyPrefix) {
        return config.get(keyPrefix + "-resource-path").asString().map(Resource::create);
    }
}

