/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.LazyValue;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class ScheduledThreadPoolSupplier
implements Supplier<ScheduledExecutorService> {
    private static final int EXECUTOR_DEFAULT_CORE_POOL_SIZE = 16;
    private static final boolean EXECUTOR_DEFAULT_IS_DAEMON = true;
    private static final String EXECUTOR_DEFAULT_THREAD_NAME_PREFIX = "helidon-";
    private static final boolean EXECUTOR_DEFAULT_PRESTART = false;
    private final int corePoolSize;
    private final boolean isDaemon;
    private final String threadNamePrefix;
    private final boolean prestart;
    private final LazyValue<ScheduledExecutorService> lazyValue = LazyValue.create(() -> Contexts.wrap((ScheduledExecutorService)this.getThreadPool()));

    private ScheduledThreadPoolSupplier(Builder builder) {
        this.corePoolSize = builder.corePoolSize;
        this.isDaemon = builder.isDaemon;
        this.threadNamePrefix = builder.threadNamePrefix;
        this.prestart = builder.prestart;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ScheduledThreadPoolSupplier create(Config config) {
        return ScheduledThreadPoolSupplier.builder().config(config).build();
    }

    public static ScheduledThreadPoolSupplier create() {
        return ScheduledThreadPoolSupplier.builder().build();
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    ScheduledThreadPoolExecutor getThreadPool() {
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(this.corePoolSize, new ThreadFactory(){
            private final AtomicInteger value = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, ScheduledThreadPoolSupplier.this.threadNamePrefix + this.value.incrementAndGet());
                t.setDaemon(ScheduledThreadPoolSupplier.this.isDaemon);
                return t;
            }
        });
        if (this.prestart) {
            result.prestartAllCoreThreads();
        }
        return result;
    }

    @Override
    public ScheduledExecutorService get() {
        return (ScheduledExecutorService)this.lazyValue.get();
    }

    public static final class Builder
    implements io.helidon.common.Builder<ScheduledThreadPoolSupplier> {
        private int corePoolSize = 16;
        private boolean isDaemon = true;
        private String threadNamePrefix = "helidon-";
        private boolean prestart = false;

        private Builder() {
        }

        public ScheduledThreadPoolSupplier build() {
            return new ScheduledThreadPoolSupplier(this);
        }

        public Builder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder daemon(boolean daemon) {
            this.isDaemon = daemon;
            return this;
        }

        public Builder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder prestart(boolean prestart) {
            this.prestart = prestart;
            return this;
        }

        public Builder config(Config config) {
            config.get("core-pool-size").asInt().ifPresent(this::corePoolSize);
            config.get("is-daemon").asBoolean().ifPresent(this::daemon);
            config.get("thread-name-prefix").asString().ifPresent(this::threadNamePrefix);
            config.get("should-prestart").asBoolean().ifPresent(this::prestart);
            return this;
        }
    }
}

