/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceException;
import io.helidon.common.configurable.ResourceImpl;
import io.helidon.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

final class ResourceUtil {
    private static final int DEFAULT_PROXY_PORT = 80;
    private static final Set<String> LOGGED_RESOURCES = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(ResourceUtil.class.getName());

    private ResourceUtil() {
    }

    static Resource from(InputStream inputStream, String description, Resource.Source resourceSource) {
        return new ResourceImpl(resourceSource, description, inputStream);
    }

    static InputStream toIs(Path fsPath) {
        Objects.requireNonNull(fsPath, "Resource file system path must not be null");
        try {
            return Files.newInputStream(fsPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ResourceException("Resource on path: " + fsPath.toAbsolutePath() + " does not exist", e);
        }
    }

    static InputStream toIs(String resPath) {
        Objects.requireNonNull(resPath, "Resource path must not be null");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resPath);
        Objects.requireNonNull(is, "Resource path does not exist: " + resPath);
        return is;
    }

    static InputStream toIs(URI uri) {
        try {
            return uri.toURL().openStream();
        }
        catch (IOException e) {
            throw new ResourceException("Failed to open stream to uri: " + uri, e);
        }
    }

    static InputStream toIs(URI uri, Proxy proxy) {
        try {
            return uri.toURL().openConnection(proxy).getInputStream();
        }
        catch (IOException e) {
            throw new ResourceException("Failed to open stream to uri: " + uri, e);
        }
    }

    static Optional<Resource> fromConfigPath(Config config) {
        return config.asString().map(x$0 -> Paths.get(x$0, new String[0])).map(Resource::create);
    }

    static Optional<Resource> fromConfigB64Content(Config config) {
        return config.asString().map(Base64.getDecoder()::decode).map(content -> Resource.create(config.key() + ".content", content));
    }

    static Optional<Resource> fromConfigContent(Config config) {
        return config.asString().map(content -> Resource.create(config.key() + ".content-plain", content));
    }

    static Optional<Resource> fromConfigUrl(Config config) {
        return config.as(URI.class).map(uri -> config.get("proxy-host").asString().map(proxyHost -> {
            if (((Boolean)config.get("use-proxy").asBoolean().orElse((Object)true)).booleanValue()) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)proxyHost, (int)((Integer)config.get("proxy-port").asInt().orElse((Object)80))));
                return Resource.create(uri, proxy);
            }
            return Resource.create(uri);
        }).orElseGet(() -> Resource.create(uri)));
    }

    static Optional<Resource> fromConfigResourcePath(Config config) {
        return config.asString().map(Resource::create);
    }

    static void logPrefixed(Config config, String prefix, String type) {
        String key = config.key().toString();
        if (LOGGED_RESOURCES.add(key + "." + prefix)) {
            LOGGER.warning("Configuration for resource on key '" + key + "." + prefix + "-" + type + "' uses old prefixed approach. Please remove the prefix and use '" + key + "." + prefix + ".resource." + type + "'");
        }
    }
}

