/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.LazyValue;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

final class VirtualExecutorUtil {
    private static final Logger LOGGER = Logger.getLogger(VirtualExecutorUtil.class.getName());
    private static final LazyValue<Boolean> SUPPORTED = LazyValue.create(VirtualExecutorUtil::findSupported);
    private static final LazyValue<ExecutorService> EXECUTOR_SERVICE = LazyValue.create(VirtualExecutorUtil::findExecutor);

    private VirtualExecutorUtil() {
    }

    static boolean isVirtualSupported() {
        return (Boolean)SUPPORTED.get();
    }

    static ExecutorService executorService() {
        ExecutorService result = (ExecutorService)EXECUTOR_SERVICE.get();
        if (result == null) {
            throw new IllegalStateException("Virtual executor service is not supported on this JVM");
        }
        return result;
    }

    private static boolean findSupported() {
        try {
            VirtualExecutorUtil.findMethod();
            return true;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.log(Level.FINEST, "Loom virtual executor service not available", e);
            return false;
        }
    }

    private static ExecutorService findExecutor() {
        try {
            return (ExecutorService)VirtualExecutorUtil.findMethod().invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.log(Level.FINEST, "Loom virtual executor service not available", e);
            return null;
        }
    }

    private static Method findMethod() throws ReflectiveOperationException {
        return Executors.class.getDeclaredMethod("newVirtualThreadExecutor", new Class[0]);
    }
}

