/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.ResourceImpl;
import io.helidon.common.configurable.ResourceUtil;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.DeprecatedConfig;
import io.helidon.config.metadata.Configured;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

@Configured
public interface Resource {
    public static Resource create(URI uri) {
        return ResourceUtil.from(ResourceUtil.toIs(uri), uri.toString(), Source.URL);
    }

    public static Resource create(URI uri, Proxy proxy) {
        return ResourceUtil.from(ResourceUtil.toIs(uri, proxy), uri.toString(), Source.URL);
    }

    public static Resource create(String resourcePath) {
        return ResourceUtil.from(ResourceUtil.toIs(resourcePath), resourcePath, Source.CLASSPATH);
    }

    public static Resource create(Path fsPath) {
        return ResourceUtil.from(ResourceUtil.toIs(fsPath), fsPath.toAbsolutePath().toString(), Source.FILE);
    }

    public static Resource create(String description, byte[] bytes) {
        Objects.requireNonNull(bytes, "Resource bytes must not be null");
        return new ResourceImpl(Source.BINARY_CONTENT, description, bytes);
    }

    public static Resource create(String description, String string) {
        Objects.requireNonNull(string, "Resource content must not be null");
        return new ResourceImpl(Source.CONTENT, description, string.getBytes(StandardCharsets.UTF_8));
    }

    public static Resource create(String description, InputStream inputStream) {
        return ResourceUtil.from(inputStream, description, Source.UNKNOWN);
    }

    public static Resource create(Config resourceConfig) {
        return ResourceUtil.fromConfigPath(resourceConfig.get("path")).or(() -> ResourceUtil.fromConfigResourcePath(resourceConfig.get("resource-path"))).or(() -> ResourceUtil.fromConfigUrl(DeprecatedConfig.get((Config)resourceConfig, (String)"uri", (String)"url"))).or(() -> ResourceUtil.fromConfigContent(resourceConfig.get("content-plain"))).or(() -> ResourceUtil.fromConfigB64Content(resourceConfig.get("content"))).orElseThrow(() -> new ConfigException("Config is not a resource configuration on key: " + resourceConfig.key() + ". The config must contain one of (path,resource-path,url,content-plain,content)"));
    }

    @Deprecated
    public static Optional<Resource> create(Config config, String prefix) {
        Optional<Resource> result = ResourceUtil.fromConfigPath(config.get(prefix + "-path"));
        if (result.isPresent()) {
            ResourceUtil.logPrefixed(config, prefix, "path");
            return result;
        }
        result = ResourceUtil.fromConfigResourcePath(config.get(prefix + "-resource-path"));
        if (result.isPresent()) {
            ResourceUtil.logPrefixed(config, prefix, "resource-path");
            return result;
        }
        result = ResourceUtil.fromConfigUrl(config.get(prefix + "-url"));
        if (result.isPresent()) {
            ResourceUtil.logPrefixed(config, prefix, "url");
            return result;
        }
        result = ResourceUtil.fromConfigContent(config.get(prefix + "-content-plain"));
        if (result.isPresent()) {
            ResourceUtil.logPrefixed(config, prefix, "content-plain");
            return result;
        }
        result = ResourceUtil.fromConfigB64Content(config.get(prefix + "-content"));
        if (result.isPresent()) {
            ResourceUtil.logPrefixed(config, prefix, "content");
            return result;
        }
        return result;
    }

    public InputStream stream();

    public byte[] bytes();

    public String string();

    public String string(Charset var1);

    public Source sourceType();

    public String location();

    public void cacheBytes();

    public static enum Source {
        FILE,
        CLASSPATH,
        URL,
        CONTENT,
        BINARY_CONTENT,
        UNKNOWN;

    }
}

