/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public interface AllowList
extends Predicate<String> {
    public static Builder builder() {
        return new Builder();
    }

    public static AllowList create(Config config) {
        return AllowList.builder().config(config).build();
    }

    @Override
    public boolean test(String var1);

    @Configured
    public static final class Builder
    implements io.helidon.common.Builder<AllowList> {
        private static final Logger LOGGER = Logger.getLogger(AllowList.class.getName());
        private final List<Predicate<String>> allowedPredicates = new ArrayList<Predicate<String>>();
        private final List<Predicate<String>> deniedPredicates = new ArrayList<Predicate<String>>();
        private boolean allowAllSetting = false;

        private Builder() {
        }

        public AllowList build() {
            this.checkAndAddAllowAllPredicate();
            return new AllowListImpl(this);
        }

        public Builder config(Config config) {
            Config allowed = config.get("allow");
            allowed.get("exact").asList(String.class).ifPresent(this::allowed);
            allowed.get("prefix").asList(String.class).ifPresent(this::allowedPrefixes);
            allowed.get("suffix").asList(String.class).ifPresent(this::allowedSuffixes);
            allowed.get("pattern").asList(Pattern.class).ifPresent(this::allowedPatterns);
            allowed.get("all").asBoolean().ifPresent(this::allowAll);
            Config denied = config.get("deny");
            denied.get("exact").asList(String.class).ifPresent(this::denied);
            denied.get("prefix").asList(String.class).ifPresent(this::deniedPrefixes);
            denied.get("suffix").asList(String.class).ifPresent(this::deniedSuffixes);
            denied.get("pattern").asList(Pattern.class).ifPresent(this::deniedPatterns);
            return this;
        }

        public Builder allowAll(boolean value) {
            this.allowAllSetting = value;
            return this;
        }

        public Builder allowed(List<String> exacts) {
            exacts.forEach(this::addAllowed);
            return this;
        }

        public Builder allowedPrefixes(List<String> prefixes) {
            prefixes.forEach(this::addAllowedPrefix);
            return this;
        }

        public Builder allowedSuffixes(List<String> suffixes) {
            suffixes.forEach(this::addAllowedSuffix);
            return this;
        }

        public Builder allowedPatterns(List<Pattern> patterns) {
            patterns.forEach(this::addAllowedPattern);
            return this;
        }

        public Builder addAllowed(String exact) {
            return this.addAllowed(new ExactPredicate(exact));
        }

        public Builder addAllowedPattern(Pattern pattern) {
            return this.addAllowed(new PatternPredicate(pattern));
        }

        public Builder addAllowedPrefix(String prefix) {
            return this.addAllowed(new PrefixPredicate(prefix));
        }

        public Builder addAllowedSuffix(String suffix) {
            return this.addAllowed(new SuffixPredicate(suffix));
        }

        public Builder addAllowed(Predicate<String> predicate) {
            this.allowedPredicates.add(predicate);
            return this;
        }

        public Builder denied(List<String> exacts) {
            exacts.forEach(this::addDenied);
            return this;
        }

        public Builder deniedPrefixes(List<String> prefixes) {
            prefixes.forEach(this::addDeniedPrefix);
            return this;
        }

        public Builder deniedSuffixes(List<String> suffixes) {
            suffixes.forEach(this::addDeniedSuffix);
            return this;
        }

        public Builder deniedPatterns(List<Pattern> patterns) {
            patterns.forEach(this::addDeniedPattern);
            return this;
        }

        public Builder addDenied(String exact) {
            return this.addDenied(new ExactPredicate(exact));
        }

        public Builder addDeniedPattern(Pattern pattern) {
            return this.addDenied(new PatternPredicate(pattern));
        }

        public Builder addDeniedPrefix(String prefix) {
            return this.addDenied(new PrefixPredicate(prefix));
        }

        public Builder addDeniedSuffix(String suffix) {
            return this.addDenied(new SuffixPredicate(suffix));
        }

        public Builder addDenied(Predicate<String> predicate) {
            this.deniedPredicates.add(predicate);
            return this;
        }

        private void checkAndAddAllowAllPredicate() {
            if (this.allowAllSetting) {
                if (!this.allowedPredicates.isEmpty()) {
                    LOGGER.log(Level.INFO, this.getClass().getSimpleName() + " allowAll=true overrides the other, more specific, allow predicates");
                }
                this.allowedPredicates.add(new AllowAllPredicate());
            }
        }

        private static final class PatternPredicate
        implements Predicate<String> {
            private final Pattern testPattern;

            private PatternPredicate(Pattern testPattern) {
                this.testPattern = testPattern;
            }

            @Override
            public boolean test(String value) {
                return this.testPattern.matcher(value).matches();
            }

            public String toString() {
                return "Pattern(" + this.testPattern.pattern() + ")";
            }
        }

        private static final class SuffixPredicate
        implements Predicate<String> {
            private final String testValue;

            private SuffixPredicate(String testValue) {
                this.testValue = testValue;
            }

            @Override
            public boolean test(String value) {
                return value.endsWith(this.testValue);
            }

            public String toString() {
                return "Suffix(" + this.testValue + ")";
            }
        }

        private static final class PrefixPredicate
        implements Predicate<String> {
            private final String testValue;

            private PrefixPredicate(String testValue) {
                this.testValue = testValue;
            }

            @Override
            public boolean test(String value) {
                return value.startsWith(this.testValue);
            }

            public String toString() {
                return "Prefix(" + this.testValue + ")";
            }
        }

        private static final class ExactPredicate
        implements Predicate<String> {
            private final String testValue;

            ExactPredicate(String exact) {
                this.testValue = exact;
            }

            @Override
            public boolean test(String value) {
                return this.testValue.equals(value);
            }

            public String toString() {
                return "Exact(" + this.testValue + ")";
            }
        }

        private static final class AllowAllPredicate
        implements Predicate<String> {
            private AllowAllPredicate() {
            }

            @Override
            public boolean test(String s) {
                return true;
            }

            public String toString() {
                return "AllowAllPredicate";
            }
        }

        private static final class AllowListImpl
        implements AllowList {
            private static final String ALLOWED_MATCHED_LOG_FORMAT = "Value '%s' is allowed by %s";
            private static final String DENIED_MATCHED_LOG_FORMAT = " but is denied by %s";
            private final List<Predicate<String>> allowedPredicates;
            private final List<Predicate<String>> deniedPredicates;

            private AllowListImpl(Builder builder) {
                this.allowedPredicates = List.copyOf(builder.allowedPredicates);
                this.deniedPredicates = List.copyOf(builder.deniedPredicates);
            }

            @Override
            public boolean test(String value) {
                for (Predicate<String> allowedPredicate : this.allowedPredicates) {
                    if (!allowedPredicate.test(value)) continue;
                    Predicate<String> deniedPredicate = this.testNotDenied(value);
                    if (deniedPredicate == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, String.format(ALLOWED_MATCHED_LOG_FORMAT, value, allowedPredicate));
                        }
                        return true;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, String.format("Value '%s' is allowed by %s but is denied by %s", value, allowedPredicate, deniedPredicate));
                    }
                    return false;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Denying value '" + value + "'; no matching allow predicates are defined");
                }
                return false;
            }

            public String toString() {
                return "Allowed: " + this.allowedPredicates + ", Denied: " + this.deniedPredicates;
            }

            private Predicate<String> testNotDenied(String value) {
                for (Predicate<String> deniedPredicate : this.deniedPredicates) {
                    if (!deniedPredicate.test(value)) continue;
                    return deniedPredicate;
                }
                return null;
            }
        }
    }
}

