/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.LazyValue;
import io.helidon.common.configurable.VirtualExecutorUtil;
import io.helidon.common.configurable.spi.ExecutorServiceSupplierObserver;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class ObserverManager {
    private static final Logger LOGGER = Logger.getLogger(ObserverManager.class.getName());
    private static final LazyValue<List<ExecutorServiceSupplierObserver>> OBSERVERS = LazyValue.create(ObserverManager::loadObservers);
    private static final Map<Supplier<? extends ExecutorService>, SupplierInfo> SUPPLIERS = new ConcurrentHashMap<Supplier<? extends ExecutorService>, SupplierInfo>();
    private static final Map<String, AtomicInteger> SUPPLIER_CATEGORY_NEXT_INDEX_VALUES = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<ExecutorService, SupplierInfo> EXECUTOR_SERVICES = new ConcurrentHashMap<ExecutorService, SupplierInfo>();
    private static final LazyValue<List<ExecutorServiceSupplierObserver.MethodInvocation>> METRICS_RELATED_METHOD_INVOCATIONS = LazyValue.create(() -> List.of(MethodInvocationImpl.create("Thread count", "thread-count", "threadCount")));

    private ObserverManager() {
    }

    static void registerSupplier(Supplier<? extends ExecutorService> supplier, String supplierCategory, String executorServiceCategory, boolean useVirtualThreads) {
        int supplierIndex = SUPPLIER_CATEGORY_NEXT_INDEX_VALUES.computeIfAbsent(supplierCategory, key -> new AtomicInteger()).getAndIncrement();
        SUPPLIERS.computeIfAbsent(supplier, s -> SupplierInfo.create(s, executorServiceCategory, supplierCategory, supplierIndex, useVirtualThreads));
    }

    static void registerSupplier(Supplier<? extends ExecutorService> supplier, String supplierCategory, String executorServiceCategory) {
        ObserverManager.registerSupplier(supplier, supplierCategory, executorServiceCategory, false);
    }

    static <E extends ExecutorService> E registerExecutorService(Supplier<E> supplier, E executorService) {
        SupplierInfo supplierInfo = SUPPLIERS.get(supplier);
        if (supplierInfo == null) {
            throw new IllegalStateException("Attempt to register an executor service to an unregistered supplier");
        }
        supplierInfo.registerExecutorService(executorService);
        return executorService;
    }

    static void unregisterExecutorService(ExecutorService executorService) {
        SupplierInfo supplierInfo = EXECUTOR_SERVICES.get(executorService);
        if (supplierInfo == null) {
            LOGGER.log(Level.WARNING, String.format("Executor service %s is being unregistered but could not locate supplier to notify observers", executorService));
            return;
        }
        supplierInfo.unregisterExecutorService(executorService);
    }

    private static List<ExecutorServiceSupplierObserver> loadObservers() {
        ServiceLoader<ExecutorServiceSupplierObserver> loader = ServiceLoader.load(ExecutorServiceSupplierObserver.class);
        return loader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
    }

    private static class SupplierInfo {
        private final Supplier<? extends ExecutorService> supplier;
        private final String executorServiceCategory;
        private final String supplierCategory;
        private final int supplierIndex;
        private final boolean useVirtualThreads;
        private final AtomicInteger nextThreadPoolIndex = new AtomicInteger(0);
        private final List<ExecutorServiceSupplierObserver.SupplierObserverContext> observerContexts;

        private static SupplierInfo create(Supplier<? extends ExecutorService> supplier, String executorServiceCategory, String supplierCategory, int supplierIndex, boolean useVirtualThreads) {
            return new SupplierInfo(supplier, supplierCategory, executorServiceCategory, supplierIndex, useVirtualThreads);
        }

        private SupplierInfo(Supplier<? extends ExecutorService> supplier, String supplierCategory, String executorServiceCategory, int supplierIndex, boolean useVirtualThreads) {
            this.supplier = supplier;
            this.supplierCategory = supplierCategory;
            this.executorServiceCategory = executorServiceCategory;
            this.supplierIndex = supplierIndex;
            this.useVirtualThreads = useVirtualThreads;
            this.observerContexts = this.collectObserverContexts();
        }

        private List<ExecutorServiceSupplierObserver.SupplierObserverContext> collectObserverContexts() {
            return ((List)OBSERVERS.get()).stream().map(observer -> this.useVirtualThreads ? observer.registerSupplier(this.supplier, this.supplierIndex, this.supplierCategory, (List)METRICS_RELATED_METHOD_INVOCATIONS.get()) : observer.registerSupplier(this.supplier, this.supplierIndex, this.supplierCategory)).collect(Collectors.toList());
        }

        void registerExecutorService(ExecutorService executorService) {
            int threadPoolIndex = this.nextThreadPoolIndex.getAndIncrement();
            EXECUTOR_SERVICES.put(executorService, this);
            this.observerContexts.forEach(observer -> observer.registerExecutorService(executorService, threadPoolIndex));
        }

        void unregisterExecutorService(ExecutorService executorService) {
            this.observerContexts.forEach(observer -> observer.unregisterExecutorService(executorService));
            EXECUTOR_SERVICES.remove(executorService);
        }
    }

    private static class MethodInvocationImpl
    implements ExecutorServiceSupplierObserver.MethodInvocation {
        private final String displayName;
        private final String description;
        private final Method method;
        private final Class<?> type;
        private static final LazyValue<ExecutorService> VIRTUAL_EXECUTOR_SERVICE = LazyValue.create(VirtualExecutorUtil::executorService);

        static MethodInvocationImpl create(String displayName, String description, String methodName) {
            ExecutorService executorService = (ExecutorService)VIRTUAL_EXECUTOR_SERVICE.get();
            Method method = null;
            try {
                method = executorService.getClass().getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            return new MethodInvocationImpl(displayName, description, method);
        }

        MethodInvocationImpl(String displayName, String description, Method method) {
            this.displayName = displayName;
            this.description = description;
            this.method = method;
            this.type = method.getReturnType();
        }

        @Override
        public String displayName() {
            return this.displayName;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public Method method() {
            return this.method;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }
    }
}

