/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public final class LruCache<K, V> {
    public static final int DEFAULT_CAPACITY = 10000;
    private final LinkedHashMap<K, V> backingMap = new LinkedHashMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final int capacity;

    private LruCache(Builder<K, V> builder) {
        this.capacity = builder.capacity;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> LruCache<K, V> create() {
        Builder<K, V> builder = LruCache.builder();
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> get(K key) {
        V value;
        this.readLock.lock();
        try {
            value = this.backingMap.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (null == value) {
            return Optional.empty();
        }
        this.writeLock.lock();
        try {
            value = this.backingMap.get(key);
            if (null == value) {
                Optional optional = Optional.empty();
                return optional;
            }
            this.backingMap.remove(key);
            this.backingMap.put(key, value);
            Optional<V> optional = Optional.of(value);
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<V> remove(K key) {
        this.writeLock.lock();
        try {
            Optional optional = Optional.ofNullable(this.backingMap.remove(key));
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> put(K key, V value) {
        this.writeLock.lock();
        try {
            Object currentValue = this.backingMap.remove(key);
            if (null == currentValue && this.backingMap.size() >= this.capacity) {
                Iterator<V> iterator = this.backingMap.values().iterator();
                iterator.next();
                iterator.remove();
            }
            this.backingMap.put(key, value);
            Optional optional = Optional.ofNullable(currentValue);
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<V> computeValue(K key, Supplier<Optional<V>> valueSupplier) {
        Optional<V> currentValue = this.get(key);
        if (currentValue.isPresent()) {
            return currentValue;
        }
        Optional<V> newValue = valueSupplier.get();
        newValue.ifPresent(theValue -> this.put(key, theValue));
        return newValue;
    }

    public int size() {
        this.readLock.lock();
        try {
            int n = this.backingMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.backingMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    V directGet(K key) {
        return this.backingMap.get(key);
    }

    @Configured
    public static class Builder<K, V>
    implements io.helidon.common.Builder<Builder<K, V>, LruCache<K, V>> {
        private int capacity = 10000;

        private Builder() {
        }

        public LruCache<K, V> build() {
            return new LruCache(this);
        }

        public Builder<K, V> config(Config config) {
            config.get("capacity").asInt().ifPresent(this::capacity);
            return this;
        }

        public Builder<K, V> capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }
    }
}

