/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class ResourceImpl
implements Resource {
    private static final System.Logger LOGGER = System.getLogger(Resource.class.getName());
    private final Resource.Source source;
    private final String location;
    private final InputStream stream;
    private volatile boolean streamObtained;
    private volatile byte[] cachedBytes;

    ResourceImpl(Resource.Source resourceSource, String location, byte[] bytes) {
        this.source = resourceSource;
        this.location = location;
        this.stream = new ByteArrayInputStream(bytes);
        this.cachedBytes = bytes;
    }

    ResourceImpl(Resource.Source resourceSource, String location, InputStream stream) {
        this.source = resourceSource;
        this.location = location;
        this.stream = stream;
    }

    @Override
    public InputStream stream() {
        this.check();
        this.streamObtained = true;
        if (null == this.cachedBytes) {
            return this.stream;
        }
        return new ByteArrayInputStream(this.cachedBytes);
    }

    @Override
    public byte[] bytes() {
        this.check();
        this.cacheBytes();
        return this.cachedBytes;
    }

    @Override
    public String string() {
        this.check();
        this.cacheBytes();
        return new String(this.cachedBytes, StandardCharsets.UTF_8);
    }

    @Override
    public String string(Charset charset) {
        this.check();
        this.cacheBytes();
        return new String(this.cachedBytes, charset);
    }

    @Override
    public Resource.Source sourceType() {
        return this.source;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public void cacheBytes() {
        if (this.cachedBytes == null) {
            try {
                this.cachedBytes = this.stream.readAllBytes();
            }
            catch (IOException e) {
                throw new ResourceException("Failed to fully read resource bytes for resource: " + String.valueOf((Object)this.source) + "(" + this.location + ")", e);
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to close input stream for resource: " + String.valueOf((Object)this.source) + "(" + this.location + ")");
                }
            }
        }
    }

    private void check() {
        if (this.streamObtained && this.cachedBytes == null) {
            throw new IllegalStateException("Once you get the stream, you cannot call other methods on this resource:" + String.valueOf((Object)this.source) + " (" + this.location + ")");
        }
    }

    public String toString() {
        return "Resource { source='" + String.valueOf((Object)this.source) + "',location='" + this.location + "'}";
    }
}

