/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.LazyValue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class VirtualExecutorUtil {
    private static final System.Logger LOGGER = System.getLogger(VirtualExecutorUtil.class.getName());
    private static final LazyValue<Boolean> SUPPORTED = LazyValue.create(VirtualExecutorUtil::findSupported);
    private static final LazyValue<ExecutorService> EXECUTOR_SERVICE = LazyValue.create(VirtualExecutorUtil::findExecutor);
    private static final List<String> SUPPORTED_METHOD_NAMES = List.of("newVirtualThreadPerTaskExecutor", "newVirtualThreadExecutor");

    private VirtualExecutorUtil() {
    }

    static boolean isVirtualSupported() {
        return (Boolean)SUPPORTED.get();
    }

    static ExecutorService executorService() {
        ExecutorService result = (ExecutorService)EXECUTOR_SERVICE.get();
        if (result == null) {
            throw new IllegalStateException("Virtual executor service is not supported on this JVM");
        }
        return result;
    }

    private static boolean findSupported() {
        try {
            VirtualExecutorUtil.findMethod();
            return true;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.log(System.Logger.Level.DEBUG, "Loom virtual executor service not available", (Throwable)e);
            return false;
        }
    }

    private static ExecutorService findExecutor() {
        try {
            return (ExecutorService)VirtualExecutorUtil.findMethod().invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.log(System.Logger.Level.DEBUG, "Loom virtual executor service not available", (Throwable)e);
            return null;
        }
    }

    private static Method findMethod() throws ReflectiveOperationException {
        ReflectiveOperationException previous = null;
        for (String methodName : SUPPORTED_METHOD_NAMES) {
            try {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Trying Loom executor method Executors." + methodName + "()");
                }
                return Executors.class.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                if (previous == null) {
                    previous = e;
                    continue;
                }
                previous.addSuppressed(e);
            }
        }
        if (previous == null) {
            throw new NoSuchMethodException("Invalid Loom configuration, no methods defined.");
        }
        throw previous;
    }
}

