/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.crypto.CryptoException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordKeyDerivation {
    private PasswordKeyDerivation() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    public static byte[] deriveKey(char[] password, byte[] salt, int iterations, int keySize) {
        return PasswordKeyDerivation.deriveKey("PBKDF2WithHmacSHA256", null, password, salt, iterations, keySize);
    }

    public static byte[] deriveKey(String algorithm, String provider, char[] password, byte[] salt, int iterations, int keySize) {
        try {
            SecretKeyFactory secretKeyFactory = provider == null ? SecretKeyFactory.getInstance(algorithm) : SecretKeyFactory.getInstance(algorithm, provider);
            PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterations, keySize);
            return secretKeyFactory.generateSecret(keySpec).getEncoded();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new CryptoException("Failed to derive the key from the password", e);
        }
    }
}

