/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.Base64Value;
import io.helidon.common.crypto.CryptoException;
import io.helidon.common.crypto.Digest;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacDigest
implements Digest {
    @Deprecated
    public static final String ALGORITHM_MD5 = "HmacMD5";
    public static final String ALGORITHM_SHA_1 = "HmacSHA1";
    public static final String ALGORITHM_SHA_224 = "HmacSHA224";
    public static final String ALGORITHM_SHA_256 = "HmacSHA256";
    public static final String ALGORITHM_SHA_384 = "HmacSHA384";
    public static final String ALGORITHM_SHA_512 = "HmacSHA512";
    public static final String ALGORITHM_SHA_512_224 = "HmacSHA512/224";
    public static final String ALGORITHM_SHA_512_256 = "HmacSHA512/256";
    private final String algorithm;
    private final String provider;
    private final byte[] hmacSecret;

    private HmacDigest(Builder builder) {
        this.algorithm = builder.algorithm;
        this.provider = builder.provider;
        this.hmacSecret = builder.hmacSecret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HmacDigest create(byte[] hmacSecret) {
        return HmacDigest.builder().hmacSecret(hmacSecret).build();
    }

    @Override
    public Base64Value digest(Base64Value value) {
        try {
            Mac mac = this.provider != null ? Mac.getInstance(this.algorithm, this.provider) : Mac.getInstance(this.algorithm);
            SecretKeySpec secretKey = new SecretKeySpec(this.hmacSecret, this.algorithm);
            mac.init(secretKey);
            return Base64Value.create((byte[])mac.doFinal(value.toBytes()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoException("Could not create hmac digest", e);
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, HmacDigest> {
        private String algorithm = "HmacSHA256";
        private String provider = null;
        private byte[] hmacSecret;

        private Builder() {
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = Objects.requireNonNull(algorithm, "Hmac type cannot be null");
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder hmacSecret(byte[] hmacSecret) {
            Objects.requireNonNull(hmacSecret, "Hmac base secret key");
            this.hmacSecret = (byte[])hmacSecret.clone();
            return this;
        }

        public HmacDigest build() {
            if (this.hmacSecret == null) {
                throw new CryptoException("Hmac secret key has to be set");
            }
            return new HmacDigest(this);
        }
    }
}

