/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;

public class ReadOnlyParameters
implements Parameters {
    private static final ReadOnlyParameters EMPTY = new ReadOnlyParameters((Parameters)null);
    private final Map<String, List<String>> data;

    public ReadOnlyParameters(Map<String, List<String>> data) {
        this.data = ReadOnlyParameters.copyMultimapAsImutable(data);
    }

    public ReadOnlyParameters(Parameters parameters) {
        this(parameters == null ? null : parameters.toMap());
    }

    public static ReadOnlyParameters empty() {
        return EMPTY;
    }

    static Map<String, List<String>> copyMultimapAsImutable(Map<String, List<String>> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap h = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        data.forEach((k, v) -> h.put(k, Collections.unmodifiableList(new ArrayList(v))));
        return Collections.unmodifiableMap(h);
    }

    @Override
    public Optional<String> first(String name) {
        return Optional.ofNullable(this.data.get(name)).map(l -> (String)l.get(0));
    }

    @Override
    public List<String> all(String name) {
        return Optional.ofNullable(this.data.get(name)).orElse(Collections.emptyList());
    }

    @Override
    public List<String> put(String key, String ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> put(String key, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> putIfAbsent(String key, String ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> putIfAbsent(String key, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Parameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(String key, String ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(String key, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(Parameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<String>> toMap() {
        HashMap<String, List<String>> h = new HashMap<String, List<String>>(this.data.size());
        this.data.forEach((k, v) -> {
            List cfr_ignored_0 = h.put((String)k, new ArrayList(v));
        });
        return h;
    }
}

