/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Http;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class SetCookie {
    private static final String PARAM_SEPARATOR = "; ";
    private final String name;
    private final String value;
    private ZonedDateTime expires;
    private Duration maxAge;
    private String domain;
    private String path;
    private boolean secure;
    private boolean httpOnly;

    public SetCookie(String name, String value) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        this.name = name;
        this.value = value;
    }

    public SetCookie expires(ZonedDateTime expires) {
        this.expires = expires;
        return this;
    }

    public SetCookie expires(Instant expires) {
        this.expires = expires == null ? null : ZonedDateTime.ofInstant(expires, ZoneId.systemDefault());
        return this;
    }

    public SetCookie maxAge(Duration maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public SetCookie domain(String domain) {
        this.domain = domain;
        return this;
    }

    public SetCookie path(String path) {
        this.path = path;
        return this;
    }

    public SetCookie domainAndPath(URI domainAndPath) {
        if (domainAndPath == null) {
            this.domain = null;
            this.path = null;
        } else {
            this.domain = domainAndPath.getHost();
            this.path = domainAndPath.getPath();
        }
        return this;
    }

    public SetCookie secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public SetCookie httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Expires=");
            result.append(this.expires.format(Http.DateTime.RFC_1123_DATE_TIME));
        }
        if (this.maxAge != null && !this.maxAge.isNegative() && !this.maxAge.isZero()) {
            result.append(PARAM_SEPARATOR);
            result.append("Max-Age=");
            result.append(this.maxAge.getSeconds());
        }
        if (this.domain != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Domain=");
            result.append(this.domain);
        }
        if (this.path != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Path=");
            result.append(this.path);
        }
        if (this.secure) {
            result.append(PARAM_SEPARATOR);
            result.append("Secure");
        }
        if (this.httpOnly) {
            result.append(PARAM_SEPARATOR);
            result.append("HttpOnly");
        }
        return result.toString();
    }
}

