/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Utils;
import java.nio.ByteBuffer;

@FunctionalInterface
public interface DataChunk {
    public static DataChunk create(ByteBuffer byteBuffer) {
        return DataChunk.create(false, byteBuffer);
    }

    public static DataChunk create(byte[] bytes) {
        return DataChunk.create(false, ByteBuffer.wrap(bytes));
    }

    public static DataChunk create(boolean flush, ByteBuffer data) {
        return DataChunk.create(flush, data, Utils.EMPTY_RUNNABLE, false);
    }

    public static DataChunk create(boolean flush, ByteBuffer data, boolean readOnly) {
        return DataChunk.create(flush, data, Utils.EMPTY_RUNNABLE, readOnly);
    }

    public static DataChunk create(boolean flush, ByteBuffer data, Runnable releaseCallback) {
        return DataChunk.create(flush, data, releaseCallback, false);
    }

    public static DataChunk create(final boolean flush, final ByteBuffer data, final Runnable releaseCallback, final boolean readOnly) {
        return new DataChunk(){
            private boolean isReleased = false;

            @Override
            public ByteBuffer data() {
                return data;
            }

            @Override
            public boolean flush() {
                return flush;
            }

            @Override
            public void release() {
                releaseCallback.run();
                this.isReleased = true;
            }

            @Override
            public boolean isReleased() {
                return this.isReleased;
            }

            @Override
            public boolean isReadOnly() {
                return readOnly;
            }
        };
    }

    public ByteBuffer data();

    default public long id() {
        return System.identityHashCode(this);
    }

    default public byte[] bytes() {
        return Utils.toByteArray(this.data().asReadOnlyBuffer());
    }

    default public boolean isReleased() {
        return false;
    }

    default public void release() {
    }

    default public boolean flush() {
        return false;
    }

    default public DataChunk duplicate() {
        byte[] bytes = new byte[this.data().limit()];
        this.data().get(bytes);
        DataChunk dup = DataChunk.create(bytes);
        dup.data().position(0);
        return dup;
    }

    default public boolean isReadOnly() {
        return false;
    }

    default public boolean isFlushChunk() {
        return this.flush() && this.data().limit() == 0;
    }
}

