/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Parameters;
import io.helidon.common.http.Utils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface Headers
extends Parameters {
    @Override
    public List<String> all(String var1);

    default public Optional<String> value(String headerName) {
        List<String> hdrs = this.all(headerName);
        if (hdrs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(hdrs.stream().collect(Collectors.joining(",")));
    }

    default public List<String> values(String headerName) {
        return this.all(headerName).stream().flatMap(val -> Utils.tokenize(',', "\"", true, val).stream()).collect(Collectors.toList());
    }
}

