/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class HashParameters
implements Parameters {
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private final ConcurrentMap<String, List<String>> content = this.emptyMapForUpdates();

    protected HashParameters() {
    }

    protected HashParameters(Map<String, List<String>> initialContent) {
        this(initialContent == null ? null : initialContent.entrySet());
    }

    protected HashParameters(Iterable<Map.Entry<String, List<String>>> initialContent) {
        this();
        if (initialContent != null) {
            initialContent.forEach(entry -> this.content.compute((String)entry.getKey(), (key, values) -> {
                if (values == null) {
                    return Collections.unmodifiableList(new ArrayList((Collection)entry.getValue()));
                }
                values.addAll((Collection)entry.getValue());
                return values;
            }));
        }
    }

    protected HashParameters(Parameters initialContent) {
        this((Iterable<Map.Entry<String, List<String>>>)initialContent);
    }

    public static HashParameters create() {
        return new HashParameters();
    }

    public static HashParameters create(Map<String, List<String>> initialContent) {
        return new HashParameters(initialContent == null ? Collections.emptySet() : initialContent.entrySet());
    }

    public static HashParameters create(Parameters initialContent) {
        return new HashParameters(initialContent);
    }

    public static HashParameters create(Iterable<Map.Entry<String, List<String>>> initialContent) {
        return new HashParameters(initialContent);
    }

    public static HashParameters concat(Parameters ... parameters) {
        return HashParameters.concat(new ArrayIterable<Parameters>(parameters));
    }

    public static HashParameters concat(Iterable<Parameters> parameters) {
        return HashParameters.concat(parameters, HashParameters::new, HashParameters::new);
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.content.entrySet().iterator();
    }

    protected static <T extends HashParameters> T concat(Iterable<? extends Iterable<Map.Entry<String, List<String>>>> contentSources, Supplier<T> emptyFactory, Function<Iterable<Map.Entry<String, List<String>>>, T> singletonFactory) {
        Iterator<? extends Iterable<Map.Entry<String, List<String>>>> sources = contentSources.iterator();
        if (!sources.hasNext()) {
            return (T)((HashParameters)emptyFactory.get());
        }
        Iterable<Map.Entry<String, List<String>>> source = sources.next();
        if (!sources.hasNext()) {
            return (T)((HashParameters)singletonFactory.apply(source));
        }
        HashMap composer = new HashMap();
        while (true) {
            if (source != null) {
                source.forEach(entry -> {
                    List strings = composer.computeIfAbsent((String)entry.getKey(), (? super K k) -> new ArrayList(((List)entry.getValue()).size()));
                    strings.addAll((Collection)entry.getValue());
                });
            }
            if (!sources.hasNext()) break;
            source = sources.next();
        }
        return (T)((HashParameters)singletonFactory.apply(composer.entrySet()));
    }

    protected ConcurrentMap<String, List<String>> emptyMapForUpdates() {
        return new ConcurrentSkipListMap<String, List<String>>();
    }

    protected Map<String, List<String>> emptyMapForReads() {
        return new HashMap<String, List<String>>();
    }

    private List<String> internalListCopy(String ... values) {
        return Optional.ofNullable(values).map(Arrays::asList).filter(l -> !l.isEmpty()).map(Collections::unmodifiableList).orElse(null);
    }

    private List<String> internalListCopy(Iterable<String> values) {
        ArrayList<String> result;
        if (values == null) {
            return null;
        }
        if (values instanceof Collection) {
            result = new ArrayList((Collection)values);
        } else {
            result = new ArrayList<String>();
            for (String value : values) {
                result.add(value);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Optional<String> first(String name) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        return this.content.getOrDefault(name, EMPTY_STRING_LIST).stream().findFirst();
    }

    @Override
    public List<String> all(String name) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        return this.content.getOrDefault(name, EMPTY_STRING_LIST);
    }

    @Override
    public List<String> put(String key, String ... values) {
        List<String> vs = this.internalListCopy(values);
        List<String> result = vs == null ? (List<String>)this.content.remove(key) : this.content.put(key, vs);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> put(String key, Iterable<String> values) {
        List<String> vs = this.internalListCopy(values);
        List<String> result = vs == null ? (List<String>)this.content.remove(key) : this.content.put(key, vs);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> putIfAbsent(String key, String ... values) {
        List<String> vls = this.internalListCopy(values);
        List<String> result = vls != null ? this.content.putIfAbsent(key, vls) : (List<String>)this.content.get(key);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> putIfAbsent(String key, Iterable<String> values) {
        List<String> vls = this.internalListCopy(values);
        List<String> result = vls != null ? this.content.putIfAbsent(key, vls) : (List<String>)this.content.get(key);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        List result = this.content.computeIfAbsent(key, (? super K k) -> this.internalListCopy((Iterable)values.apply((String)k)));
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        List result = this.content.computeIfAbsent(key, (? super K k) -> {
            String v = (String)value.apply((String)k);
            if (v == null) {
                return null;
            }
            return Collections.singletonList(v);
        });
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public HashParameters putAll(Parameters parameters) {
        if (parameters == null) {
            return this;
        }
        for (Map.Entry<String, List<String>> entry : parameters.toMap().entrySet()) {
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            this.content.put(entry.getKey(), Collections.unmodifiableList(values));
        }
        return this;
    }

    @Override
    public HashParameters add(String key, String ... values) {
        Objects.requireNonNull(key, "Parameter 'key' is null!");
        if (values == null || values.length == 0) {
            return this;
        }
        this.content.compute(key, (s, list) -> {
            if (list == null) {
                return Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(values)));
            }
            ArrayList<String> newValues = new ArrayList<String>(list.size() + values.length);
            newValues.addAll((Collection<String>)list);
            newValues.addAll(Arrays.asList(values));
            return Collections.unmodifiableList(newValues);
        });
        return this;
    }

    @Override
    public HashParameters add(String key, Iterable<String> values) {
        Objects.requireNonNull(key, "Parameter 'key' is null!");
        List<String> vls = this.internalListCopy(values);
        if (vls == null) {
            return this;
        }
        this.content.compute(key, (s, list) -> {
            if (list == null) {
                return Collections.unmodifiableList(vls);
            }
            ArrayList newValues = new ArrayList(list.size() + vls.size());
            newValues.addAll(list);
            newValues.addAll(vls);
            return Collections.unmodifiableList(newValues);
        });
        return this;
    }

    @Override
    public HashParameters addAll(Parameters parameters) {
        if (parameters == null) {
            return this;
        }
        Map<String, List<String>> map = parameters.toMap();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public List<String> remove(String key) {
        List result = (List)this.content.remove(key);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public Map<String, List<String>> toMap() {
        Map<String, List<String>> result = this.emptyMapForReads();
        for (Map.Entry entry : this.content.entrySet()) {
            result.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }

    public String toString() {
        return this.content.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashParameters that = (HashParameters)o;
        return this.content.equals(that.content);
    }

    public int hashCode() {
        return 37 * this.getClass().hashCode() + this.content.hashCode();
    }

    protected static class ArrayIterable<T>
    implements Iterable<T> {
        private final T[] content;

        protected ArrayIterable(T[] content) {
            this.content = content;
        }

        @Override
        public Iterator<T> iterator() {
            return this.content == null ? Collections.emptyIterator() : new Iterator<T>(){
                private int slot = 0;

                @Override
                public boolean hasNext() {
                    return this.slot < content.length;
                }

                @Override
                public T next() {
                    if (this.slot >= content.length) {
                        throw new NoSuchElementException();
                    }
                    return content[this.slot++];
                }
            };
        }
    }
}

