/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReadOnlyParameters
implements Parameters {
    private static final ReadOnlyParameters EMPTY = new ReadOnlyParameters((Parameters)null);
    private final Map<String, List<String>> data;

    public ReadOnlyParameters(Map<String, List<String>> data) {
        this(data == null ? Collections.emptySet() : data.entrySet());
    }

    public ReadOnlyParameters(Parameters parameters) {
        this((Iterable<Map.Entry<String, List<String>>>)parameters);
    }

    protected ReadOnlyParameters(Iterable<Map.Entry<String, List<String>>> data) {
        this.data = ReadOnlyParameters.copyMultimapAsImmutable(data, this::emptyMap);
    }

    public static ReadOnlyParameters empty() {
        return EMPTY;
    }

    static Map<String, List<String>> copyMultimapAsImutable(Map<String, List<String>> data) {
        return ReadOnlyParameters.copyMultimapAsImmutable(data == null ? null : data.entrySet(), ReadOnlyParameters::createEmptyMap);
    }

    static Map<String, List<String>> copyMultimapAsImmutable(Iterable<Map.Entry<String, List<String>>> data, Supplier<? extends Map<String, List<String>>> mapFactory) {
        if (data == null) {
            return Collections.emptyMap();
        }
        Iterator<Map.Entry<String, List<String>>> entries = data.iterator();
        if (!entries.hasNext()) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> h = mapFactory.get();
        while (entries.hasNext()) {
            Map.Entry<String, List<String>> entry = entries.next();
            if (entry == null) continue;
            h.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
        }
        return Collections.unmodifiableMap(h);
    }

    @Override
    public Optional<String> first(String name) {
        return Optional.ofNullable(this.data.get(name)).map(l -> !l.isEmpty() ? (String)l.get(0) : null);
    }

    @Override
    public List<String> all(String name) {
        return Optional.ofNullable(this.data.get(name)).orElse(Collections.emptyList());
    }

    @Override
    public List<String> put(String key, String ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> put(String key, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> putIfAbsent(String key, String ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> putIfAbsent(String key, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReadOnlyParameters putAll(Parameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReadOnlyParameters add(String key, String ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReadOnlyParameters add(String key, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReadOnlyParameters addAll(Parameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<String>> toMap() {
        Map<String, List<String>> h = this.emptyMapForCopy();
        this.data.forEach((? super K k, ? super V v) -> h.put((String)k, new ArrayList(v)));
        return h;
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.data.entrySet().iterator();
    }

    protected Map<String, List<String>> emptyMap() {
        return ReadOnlyParameters.createEmptyMap();
    }

    protected Map<String, List<String>> emptyMapForCopy() {
        return new HashMap<String, List<String>>(this.data.size());
    }

    private static Map<String, List<String>> createEmptyMap() {
        return new HashMap<String, List<String>>();
    }
}

