/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.UnmodifiableParameters;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface Parameters
extends Iterable<Map.Entry<String, List<String>>> {
    public static Parameters toUnmodifiableParameters(Parameters parameters) {
        Objects.requireNonNull(parameters, "Parameter 'parameters' is null!");
        return new UnmodifiableParameters(parameters);
    }

    public Optional<String> first(String var1);

    public List<String> all(String var1);

    public List<String> put(String var1, String ... var2);

    public List<String> put(String var1, Iterable<String> var2);

    public List<String> putIfAbsent(String var1, String ... var2);

    public List<String> putIfAbsent(String var1, Iterable<String> var2);

    public List<String> computeIfAbsent(String var1, Function<String, Iterable<String>> var2);

    public List<String> computeSingleIfAbsent(String var1, Function<String, String> var2);

    public Parameters putAll(Parameters var1);

    public Parameters add(String var1, String ... var2);

    public Parameters add(String var1, Iterable<String> var2);

    public Parameters addAll(Parameters var1);

    public List<String> remove(String var1);

    public Map<String, List<String>> toMap();

    @Override
    default public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.toMap().entrySet().iterator();
    }
}

