/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.ClientResponseHeadersImpl;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface ClientResponseHeaders
extends Headers {
    public static ClientResponseHeaders create(Headers responseHeaders) {
        return new ClientResponseHeadersImpl(responseHeaders);
    }

    default public List<HttpMediaType> acceptPatches() {
        List<String> all = this.all(Http.Header.ACCEPT_PATCH, List::of);
        ArrayList<HttpMediaType> mediaTypes = new ArrayList<HttpMediaType>(all.size());
        for (String value : all) {
            mediaTypes.add(HttpMediaType.create(value));
        }
        return mediaTypes;
    }

    default public Optional<URI> location() {
        if (this.contains(Http.Header.LOCATION)) {
            return Optional.of(this.get(Http.Header.LOCATION)).map(Http.HeaderValue::value).map(URI::create);
        }
        return Optional.empty();
    }

    default public Optional<ZonedDateTime> lastModified() {
        if (this.contains(Http.Header.LAST_MODIFIED)) {
            return Optional.of(this.get(Http.Header.LAST_MODIFIED)).map(Http.HeaderValue::value).map(Http.DateTime::parse);
        }
        return Optional.empty();
    }

    default public Optional<ZonedDateTime> expires() {
        if (this.contains(Http.Header.EXPIRES)) {
            return Optional.of(this.get(Http.Header.EXPIRES)).map(Http.HeaderValue::value).map(Http.DateTime::parse);
        }
        return Optional.empty();
    }
}

