/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Http;
import io.helidon.common.mapper.MapperManager;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentDisposition
implements Http.HeaderValue {
    private static final String NAME_PARAMETER = "name";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String CREATION_DATE_PARAMETER = "creation-date";
    private static final String MODIFICATION_DATE_PARAMETER = "modification-date";
    private static final String READ_DATE_PARAMETER = "read-date";
    private static final String SIZE_PARAMETER = "size";
    private static final MapperManager MAPPER_MANAGER = MapperManager.create();
    private static final ContentDisposition EMPTY = ContentDisposition.builder().type("").build();
    private static final Pattern DISPOSITION_PART_PATTERN = Pattern.compile("^(.+?)=\"?(.+?)\"?$");
    private final String type;
    private final Map<String, String> parameters;
    private String value;

    private ContentDisposition(Builder builder) {
        this.type = builder.type;
        this.parameters = new LinkedHashMap<String, String>(builder.parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ContentDisposition parse(String headerValue) {
        Builder builder = ContentDisposition.builder();
        String[] parts = headerValue.split("(?<=[^\\\\]);");
        if (parts.length > 0) {
            String type = parts[0];
            if (type.indexOf(61) > -1) {
                throw new IllegalArgumentException("No type defined");
            }
            builder.type(type.trim());
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                Matcher matcher = DISPOSITION_PART_PATTERN.matcher(part.trim());
                if (!matcher.matches()) continue;
                String name = matcher.group(1);
                String value = matcher.group(2);
                value = value.replace("\\\\", "\\");
                value = value.replace("\\\"", "\"");
                value = value.replace("\\;", ";");
                builder.parameter(name, value);
            }
        }
        return builder.build();
    }

    public static ContentDisposition empty() {
        return EMPTY;
    }

    @Override
    public String name() {
        return Http.Header.CONTENT_DISPOSITION.defaultCase();
    }

    @Override
    public Http.HeaderName headerName() {
        return Http.Header.CONTENT_DISPOSITION;
    }

    @Override
    public String value() {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type);
            for (Map.Entry<String, String> param : this.parameters.entrySet()) {
                sb.append(";");
                sb.append(param.getKey());
                sb.append("=");
                if (SIZE_PARAMETER.equals(param.getKey())) {
                    sb.append(param.getValue());
                    continue;
                }
                sb.append("\"");
                sb.append(param.getValue());
                sb.append("\"");
            }
            this.value = sb.toString();
        }
        return this.value;
    }

    @Override
    public <T> T value(Class<T> type) {
        return (T)MAPPER_MANAGER.map((Object)this.value(), String.class, type, new String[]{"http-header"});
    }

    @Override
    public List<String> allValues() {
        return List.of(this.value());
    }

    @Override
    public int valueCount() {
        return 1;
    }

    @Override
    public boolean sensitive() {
        return false;
    }

    @Override
    public boolean changing() {
        return true;
    }

    public String toString() {
        return this.value();
    }

    public Optional<String> contentName() {
        return Optional.ofNullable(this.parameters.get(NAME_PARAMETER));
    }

    public Optional<String> filename() {
        String filename = null;
        String value = this.parameters.get(FILENAME_PARAMETER);
        if (value != null) {
            filename = URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
        return Optional.ofNullable(filename);
    }

    public Optional<ZonedDateTime> creationDate() {
        return Optional.ofNullable(this.parameters.get(CREATION_DATE_PARAMETER)).map(Http.DateTime::parse);
    }

    public Optional<ZonedDateTime> modificationDate() {
        return Optional.ofNullable(this.parameters.get(MODIFICATION_DATE_PARAMETER)).map(Http.DateTime::parse);
    }

    public Optional<ZonedDateTime> readDate() {
        return Optional.ofNullable(this.parameters.get(READ_DATE_PARAMETER)).map(Http.DateTime::parse);
    }

    public OptionalLong size() {
        String size = this.parameters.get(SIZE_PARAMETER);
        if (size != null) {
            return OptionalLong.of(Long.parseLong(size));
        }
        return OptionalLong.empty();
    }

    public Map<String, String> parameters() {
        return Map.copyOf(this.parameters);
    }

    public String type() {
        return this.type;
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ContentDisposition> {
        public static final String TYPE_FORM_DATA = "form-data";
        private final Map<String, String> parameters = new LinkedHashMap<String, String>();
        private String type = "form-data";

        private Builder() {
        }

        public ContentDisposition build() {
            return new ContentDisposition(this);
        }

        public Builder type(String type) {
            this.type = type.toLowerCase();
            return this;
        }

        public Builder name(String name) {
            this.parameters.put(ContentDisposition.NAME_PARAMETER, name);
            return this;
        }

        public Builder filename(String filename) {
            this.parameters.put(ContentDisposition.FILENAME_PARAMETER, URLEncoder.encode(filename, StandardCharsets.UTF_8));
            return this;
        }

        public Builder creationDate(ZonedDateTime date) {
            this.parameters.put(ContentDisposition.CREATION_DATE_PARAMETER, date.format(Http.DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder modificationDate(ZonedDateTime date) {
            this.parameters.put(ContentDisposition.MODIFICATION_DATE_PARAMETER, date.format(Http.DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder readDate(ZonedDateTime date) {
            this.parameters.put(ContentDisposition.READ_DATE_PARAMETER, date.format(Http.DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder size(long size) {
            this.parameters.put(ContentDisposition.SIZE_PARAMETER, Long.toString(size));
            return this;
        }

        public Builder parameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }
    }
}

