/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.HeaderEnum;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.IntSet;
import io.helidon.common.http.WritableHeaders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;

class HeadersImpl<T extends WritableHeaders<T>>
implements WritableHeaders<T> {
    static final int KNOWN_HEADER_SIZE = HeaderEnum.values().length;
    private final Http.HeaderValue[] knownHeaders = new Http.HeaderValue[KNOWN_HEADER_SIZE];
    private final Map<Http.HeaderName, Http.HeaderValue> customHeaders = new HashMap<Http.HeaderName, Http.HeaderValue>();
    private IntSet knownHeaderIndices = new IntSet(KNOWN_HEADER_SIZE);

    HeadersImpl() {
    }

    HeadersImpl(Headers headers) {
        for (Http.HeaderValue header : headers) {
            this.set(header);
        }
    }

    @Override
    public List<String> all(Http.HeaderName name, Supplier<List<String>> defaultSupplier) {
        Http.HeaderValue headerValue = this.find(name);
        if (headerValue == null) {
            return defaultSupplier.get();
        }
        return headerValue.allValues();
    }

    @Override
    public boolean contains(Http.HeaderName name) {
        return this.find(name) != null;
    }

    @Override
    public boolean contains(Http.HeaderValue headerWithValue) {
        Http.HeaderValue headerValue = this.find(headerWithValue.headerName());
        if (headerValue == null) {
            return false;
        }
        if (headerWithValue.valueCount() == 1 && headerValue.valueCount() == 1) {
            return headerWithValue.value().equals(headerValue.value());
        }
        return headerWithValue.allValues().equals(headerValue.allValues());
    }

    @Override
    public Http.HeaderValue get(Http.HeaderName name) {
        Http.HeaderValue headerValue = this.find(name);
        if (headerValue == null) {
            throw new NoSuchElementException("Header " + String.valueOf(name) + " is not present in these headers");
        }
        return headerValue;
    }

    @Override
    public int size() {
        return this.customHeaders.size() + this.knownHeaderIndices.size();
    }

    @Override
    public List<HttpMediaType> acceptedTypes() {
        if (this.contains(Http.Header.ACCEPT)) {
            List<String> accepts = this.get(Http.Header.ACCEPT).allValues(true);
            ArrayList<HttpMediaType> mediaTypes = new ArrayList<HttpMediaType>(accepts.size());
            for (String accept : accepts) {
                mediaTypes.add(HttpMediaType.create(accept));
            }
            Collections.sort(mediaTypes);
            return mediaTypes;
        }
        return List.of();
    }

    @Override
    public Iterator<Http.HeaderValue> iterator() {
        return new HeaderIterator();
    }

    @Override
    public T setIfAbsent(Http.HeaderValue header) {
        Http.HeaderValue found = this.find(header.headerName());
        if (found == null) {
            this.set(header);
        }
        return (T)this;
    }

    @Override
    public T add(Http.HeaderValue header) {
        Http.HeaderName name = header.headerName();
        Http.HeaderValue headerValue = this.find(name);
        if (headerValue == null) {
            this.set(header);
        } else {
            Http.HeaderValueWriteable hvw;
            Http.HeaderValueWriteable writable = headerValue instanceof Http.HeaderValueWriteable ? (hvw = (Http.HeaderValueWriteable)headerValue) : Http.HeaderValueWriteable.create(header);
            for (String value : header.allValues()) {
                writable.addValue(value);
            }
            this.set(writable);
        }
        return (T)this;
    }

    @Override
    public T remove(Http.HeaderName name) {
        this.doRemove(name);
        return (T)this;
    }

    @Override
    public T remove(Http.HeaderName name, Consumer<Http.HeaderValue> removedConsumer) {
        Http.HeaderValue remove = this.doRemove(name);
        if (remove != null) {
            removedConsumer.accept(remove);
        }
        return (T)this;
    }

    @Override
    public T set(Http.HeaderValue header) {
        Http.HeaderName name = header.headerName();
        int index = name.index();
        if (index == -1) {
            this.customHeaders.put(name, header);
        } else {
            this.knownHeaders[index] = header;
            this.knownHeaderIndices.add(index);
        }
        return (T)this;
    }

    @Override
    public T clear() {
        Arrays.fill(this.knownHeaders, null);
        this.knownHeaderIndices = new IntSet(KNOWN_HEADER_SIZE);
        this.customHeaders.clear();
        return (T)this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Http.HeaderValue headerValue : this) {
            for (String value : headerValue.allValues()) {
                builder.append(headerValue.name()).append(": ");
                if (headerValue.sensitive()) {
                    builder.append("*".repeat(value.length()));
                } else {
                    builder.append(value);
                }
                ArrayList<String> details = new ArrayList<String>(2);
                if (headerValue.sensitive()) {
                    details.add("sensitive");
                }
                if (headerValue.changing()) {
                    details.add("changing");
                }
                if (!details.isEmpty()) {
                    builder.append(" (");
                    builder.append(String.join((CharSequence)", ", details));
                    builder.append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public Http.HeaderValue doRemove(Http.HeaderName name) {
        if (name instanceof HeaderEnum) {
            int index = ((HeaderEnum)name).ordinal();
            Http.HeaderValue value = this.knownHeaders[index];
            this.knownHeaders[index] = null;
            this.knownHeaderIndices.remove(index);
            return value;
        }
        return this.customHeaders.remove(name);
    }

    private Http.HeaderValue find(Http.HeaderName name) {
        int index = name.index();
        if (index > -1) {
            return this.knownHeaders[index];
        }
        return this.customHeaders.get(name);
    }

    private class HeaderIterator
    implements Iterator<Http.HeaderValue> {
        private final boolean noCustom;
        private boolean inKnown;
        private int last;
        private Iterator<Http.HeaderValue> customHeadersIterator;

        private HeaderIterator() {
            this.noCustom = HeadersImpl.this.customHeaders.isEmpty();
            this.inKnown = true;
            this.last = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.inKnown) {
                this.last = HeadersImpl.this.knownHeaderIndices.nextSetBit(this.last + 1);
                if (this.last >= 0) {
                    return true;
                }
                this.inKnown = false;
                if (this.noCustom) {
                    return false;
                }
                this.ensureCustom();
            }
            return this.customHeadersIterator.hasNext();
        }

        @Override
        public Http.HeaderValue next() {
            if (this.last >= 0) {
                return HeadersImpl.this.knownHeaders[this.last];
            }
            this.ensureCustom();
            return this.customHeadersIterator.next();
        }

        private void ensureCustom() {
            if (this.customHeadersIterator == null) {
                this.customHeadersIterator = HeadersImpl.this.customHeaders.values().iterator();
            }
        }
    }
}

