/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

public final class HttpToken {
    private HttpToken() {
    }

    public static void validate(String token) throws IllegalArgumentException {
        char[] chars;
        for (char aChar : chars = token.toCharArray()) {
            if (aChar > '\u00fe') {
                throw new IllegalArgumentException("Token contains non-ASCII character");
            }
            if (Character.isISOControl(aChar)) {
                throw new IllegalArgumentException("Token contains control character");
            }
            if (Character.isWhitespace(aChar)) {
                throw new IllegalArgumentException("Token contains whitespace character");
            }
            switch (aChar) {
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    throw new IllegalArgumentException("Token contains illegal character: " + aChar);
                }
            }
        }
    }
}

