/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.HeaderEnum;
import io.helidon.common.http.Headers;
import io.helidon.common.http.HeadersImpl;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.media.type.MediaType;
import java.util.List;
import java.util.function.Consumer;

public interface WritableHeaders<B extends WritableHeaders<B>>
extends Headers {
    public static WritableHeaders<?> create() {
        return new HeadersImpl();
    }

    public static WritableHeaders<?> create(Headers headers) {
        return new HeadersImpl(headers);
    }

    public B setIfAbsent(Http.HeaderValue var1);

    public B add(Http.HeaderValue var1);

    default public B add(Http.HeaderName header, String ... value) {
        return this.add(Http.Header.create(header, value));
    }

    public B remove(Http.HeaderName var1);

    public B remove(Http.HeaderName var1, Consumer<Http.HeaderValue> var2);

    default public B contentType(MediaType contentType) {
        return this.set(Http.Header.create((Http.HeaderName)HeaderEnum.CONTENT_TYPE, contentType.text()));
    }

    default public B contentType(HttpMediaType contentType) {
        return this.set(Http.Header.create((Http.HeaderName)HeaderEnum.CONTENT_TYPE, contentType.text()));
    }

    public B set(Http.HeaderValue var1);

    default public B set(Http.HeaderName name, String ... values) {
        return this.set(Http.Header.create(name, true, false, values));
    }

    default public B set(Http.HeaderName name, List<String> values) {
        return this.set(Http.Header.create(name, values));
    }

    default public B contentLength(long length) {
        return this.set(Http.Header.create((Http.HeaderName)HeaderEnum.CONTENT_LENGTH, true, false, String.valueOf(length)));
    }

    public B clear();
}

