/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.configurable.Resource;
import io.helidon.common.pki.KeystoreKeys;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import java.util.List;
import java.util.Optional;

@Configured
@Prototype.Blueprint
@Prototype.CustomMethods(value=CustomMethods.class)
interface KeystoreKeysBlueprint {
    public static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    public static final String DEFAULT_PRIVATE_KEY_ALIAS = "1";

    @ConfiguredOption(required=true, key="resource")
    public Resource keystore();

    @ConfiguredOption(value="PKCS12")
    public String type();

    @Option.Confidential
    @ConfiguredOption
    public Optional<char[]> passphrase();

    @ConfiguredOption(key="key.alias")
    public Optional<String> keyAlias();

    @ConfiguredOption(key="key.passphrase")
    @Option.Confidential
    public Optional<char[]> keyPassphrase();

    @ConfiguredOption(key="cert.alias")
    public Optional<String> certAlias();

    @ConfiguredOption(key="cert-chain.alias")
    public Optional<String> certChainAlias();

    @Option.Singular(value="certAlias")
    public List<String> certAliases();

    @ConfiguredOption(value="false")
    public boolean trustStore();

    public static final class CustomMethods {
        private CustomMethods() {
        }

        @Deprecated(forRemoval=true, since="4.0.0")
        @Prototype.BuilderMethod
        static void keystorePassphrase(KeystoreKeys.BuilderBase<?, ?> builder, String passphrase) {
            builder.passphrase(passphrase);
        }
    }
}

