/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManagerImpl;
import io.helidon.common.mapper.spi.MapperProvider;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public interface MapperManager {
    public static Builder builder() {
        return new Builder();
    }

    public static MapperManager create() {
        return MapperManager.builder().build();
    }

    public static Builder builder(HelidonServiceLoader<MapperProvider> serviceLoader) {
        return MapperManager.builder().mapperProviders((HelidonServiceLoader<MapperProvider>)serviceLoader);
    }

    public static MapperManager create(HelidonServiceLoader<MapperProvider> serviceLoader) {
        return MapperManager.builder().mapperProviders((HelidonServiceLoader<MapperProvider>)serviceLoader).build();
    }

    public <SOURCE, TARGET> TARGET map(SOURCE var1, GenericType<SOURCE> var2, GenericType<TARGET> var3) throws MapperException;

    public <SOURCE, TARGET> TARGET map(SOURCE var1, Class<SOURCE> var2, Class<TARGET> var3) throws MapperException;

    public static final class Builder
    implements io.helidon.common.Builder<MapperManager> {
        private HelidonServiceLoader.Builder<MapperProvider> providers = HelidonServiceLoader.builder(ServiceLoader.load(MapperProvider.class));

        private Builder() {
        }

        public MapperManager build() {
            return new MapperManagerImpl(this);
        }

        private Builder mapperProviders(HelidonServiceLoader<MapperProvider> serviceLoader) {
            this.providers = HelidonServiceLoader.builder(ServiceLoader.load(MapperProvider.class)).useSystemServiceLoader(false);
            serviceLoader.forEach(arg_0 -> this.providers.addService(arg_0));
            return this;
        }

        public Builder addMapperProvider(MapperProvider provider) {
            this.providers.addService((Object)provider);
            return this;
        }

        public Builder addMapperProvider(MapperProvider provider, int priority) {
            this.providers.addService((Object)provider, priority);
            return this;
        }

        public <S, T> Builder addMapper(Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType) {
            return this.addMapper(mapper, sourceType, targetType, 5000);
        }

        public <S, T> Builder addMapper(final Mapper<S, T> mapper, final Class<S> sourceType, final Class<T> targetType, int priority) {
            this.providers.addService((Object)new MapperProvider(){

                public <FROM, TO> Optional<Mapper<?, ?>> mapper(Class<FROM> sourceClass, Class<TO> targetClass) {
                    if (sourceType == sourceClass && targetType == targetClass) {
                        return Optional.of(mapper);
                    }
                    return Optional.empty();
                }
            }, priority);
            return this;
        }

        public <S, T> Builder addMapper(Mapper<S, T> mapper, GenericType<S> sourceType, GenericType<T> targetType) {
            return this.addMapper(mapper, sourceType, targetType, 5000);
        }

        public <S, T> Builder addMapper(final Mapper<S, T> mapper, final GenericType<S> sourceType, final GenericType<T> targetType, int priority) {
            this.providers.addService((Object)new MapperProvider(){

                public <FROM, TO> Optional<Mapper<?, ?>> mapper(Class<FROM> sourceClass, Class<TO> targetClass) {
                    return Optional.empty();
                }

                public <FROM, TO> Optional<Mapper<?, ?>> mapper(GenericType<FROM> sourceClass, GenericType<TO> targetClass) {
                    if (sourceType.equals(sourceClass) && targetType.equals(targetClass)) {
                        return Optional.of(mapper);
                    }
                    return Optional.empty();
                }
            }, priority);
            return this;
        }

        List<MapperProvider> mapperProviders() {
            return this.providers.build().asList();
        }
    }
}

